/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi;

import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.constants.MetricClusterRollupType;
import com.singularity.ee.controller.api.constants.MetricHoleHandlingType;
import com.singularity.ee.controller.api.constants.MetricTimeRollupType;
import com.singularity.ee.controller.api.dto.RawMetricIdentifier;
import com.singularity.ee.util.javaspecific.atomic.AgentVolatileLongImpl;
import com.singularity.ee.util.spi.IAgentVolatileLong;
import com.singularity.ee.util.xml.XMLParseUtility;

public class AgentRawMetricIdentifier {
    private IAgentVolatileLong id;
    private final String name;
    private final MetricTimeRollupType timeRollupType;
    private final MetricClusterRollupType clusterRollupType;
    private final MetricHoleHandlingType holeType;
    private final int hashValue;
    private MetricAggregatorType metricAggregatorType;

    public AgentRawMetricIdentifier(String name, MetricAggregatorType aggregatorType, MetricTimeRollupType timeRollupType, MetricClusterRollupType clusterRollupType, MetricHoleHandlingType holeType) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (aggregatorType == null) {
            throw new IllegalArgumentException("Aggregator type cannot be null");
        }
        this.name = this.sanitizeName(name);
        this.metricAggregatorType = aggregatorType;
        this.timeRollupType = timeRollupType;
        this.clusterRollupType = clusterRollupType;
        this.holeType = holeType;
        this.id = new AgentVolatileLongImpl(0L);
        this.hashValue = name.hashCode();
    }

    private String sanitizeName(String name) {
        StringBuffer sanitized = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (!XMLParseUtility.isValidChar(c)) continue;
            sanitized.append(c);
        }
        return sanitized.toString();
    }

    public MetricHoleHandlingType getHoleType() {
        return this.holeType;
    }

    public long getId() {
        return this.id.get();
    }

    public void setId(long idVal) {
        this.id.set(idVal);
    }

    public MetricTimeRollupType getTimeRollupType() {
        return this.timeRollupType;
    }

    public MetricClusterRollupType getClusterRollupType() {
        return this.clusterRollupType;
    }

    public MetricAggregatorType getMetricAggregatorType() {
        return this.metricAggregatorType;
    }

    @Deprecated
    public void setMetricAggregatorType(MetricAggregatorType aggregatorType) {
        this.metricAggregatorType = aggregatorType;
    }

    public String getName() {
        return this.name;
    }

    public int hashCode() {
        return this.hashValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof AgentRawMetricIdentifier)) {
            return false;
        }
        AgentRawMetricIdentifier other = (AgentRawMetricIdentifier)o;
        if (this.id.get() != 0L && other.id.get() == this.id.get()) {
            return true;
        }
        return other.name.equals(this.name);
    }

    public String toString() {
        return "Metric Identifier[" + this.name + "] ID[" + this.id + "]";
    }

    public RawMetricIdentifier toDTO() {
        RawMetricIdentifier dto = new RawMetricIdentifier();
        dto.setName(this.name);
        dto.setClusterRollupType(this.clusterRollupType);
        dto.setHoleType(this.holeType);
        dto.setId(this.id.get());
        dto.setTimeRollupType(this.timeRollupType);
        dto.setLiteAlertConfigId(null);
        return dto;
    }
}

