/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.metrics;

import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.AgentRawMetricData;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.logging.ILogger;
import java.util.HashMap;
import java.util.Map;

public class RawMetrics {
    private AgentRawMetricData[] registeredMetrics;
    private AgentRawMetricData[] unregisteredMetrics;
    private Map<Long, AgentRawMetricData> metricIdVsRawMetricData = new HashMap<Long, AgentRawMetricData>();

    public RawMetrics(AgentRawMetricData[] registeredMetrics, AgentRawMetricData[] unregisteredMetrics) {
        this.registeredMetrics = registeredMetrics;
        this.unregisteredMetrics = unregisteredMetrics;
    }

    public AgentRawMetricData[] getRegisteredMetrics() {
        return this.registeredMetrics;
    }

    public void setRegisteredMetrics(AgentRawMetricData[] registeredMetrics) {
        this.registeredMetrics = registeredMetrics;
    }

    public AgentRawMetricData[] getUnregisteredMetrics() {
        return this.unregisteredMetrics;
    }

    public void setUnregisteredMetrics(AgentRawMetricData[] unregisteredMetrics) {
        this.unregisteredMetrics = unregisteredMetrics;
    }

    public synchronized void fixDuplicateMetrics(ILogger logger) {
        this.metricIdVsRawMetricData.clear();
        boolean hasMergedMetrics = false;
        for (AgentRawMetricData metric : this.registeredMetrics) {
            AgentRawMetricData exists = this.metricIdVsRawMetricData.get(metric.getMetricIdentifier().getId());
            if (exists == null) {
                this.metricIdVsRawMetricData.put(metric.getMetricIdentifier().getId(), metric);
                continue;
            }
            hasMergedMetrics = true;
            this.safeMergeDuplicateMetricData(exists, metric, logger);
        }
        if (hasMergedMetrics) {
            this.registeredMetrics = (AgentRawMetricData[])CollectionHelper.collectionToArray(this.metricIdVsRawMetricData.values(), (Object[])new AgentRawMetricData[this.metricIdVsRawMetricData.size()]);
        }
    }

    private void safeMergeDuplicateMetricData(AgentRawMetricData exists, AgentRawMetricData duplicate, ILogger logger) {
        try {
            this.mergeDuplicateMetricData(exists, duplicate, logger);
        }
        catch (Throwable t) {
            StringBuilder sb = new StringBuilder();
            sb.append("Failed to merge duplicate metric data");
            if (exists != null) {
                sb.append(", existing=" + exists.getMetricIdentifier());
            }
            if (duplicate != null) {
                sb.append(", duplicate=" + duplicate.getMetricIdentifier());
            }
            logger.warn(sb.toString(), t);
        }
    }

    private void mergeDuplicateMetricData(AgentRawMetricData exists, AgentRawMetricData duplicate, ILogger logger) {
        RawMetricValue existsMetricValue = new RawMetricValue(exists.getMetricValue());
        exists.setMetricValue(existsMetricValue);
        RawMetricValue duplicateMetricValue = duplicate.getMetricValue();
        MetricAggregatorType existsAggregatorType = exists.getMetricIdentifier().getMetricAggregatorType();
        MetricAggregatorType duplicateAggregatorType = duplicate.getMetricIdentifier().getMetricAggregatorType();
        if (existsAggregatorType == null && duplicateAggregatorType == null) {
            logger.warn("Attempt to merge two metric data objects (name: " + exists.getMetricIdentifier().getName() + ") with null aggregator types");
            return;
        }
        if (existsAggregatorType == null) {
            exists.getMetricIdentifier().setMetricAggregatorType(duplicateAggregatorType);
            existsAggregatorType = duplicateAggregatorType;
            logger.warn("Existing metric data (name: " + exists.getMetricIdentifier().getName() + ") has a null aggregator type");
        } else if (duplicateAggregatorType == null) {
            duplicate.getMetricIdentifier().setMetricAggregatorType(existsAggregatorType);
            logger.warn("Duplicate metric data (name: " + exists.getMetricIdentifier().getName() + ") has a null aggregator type");
        }
        switch (existsAggregatorType) {
            case AVERAGE: 
            case ADVANCED_AVERAGE: {
                existsMetricValue.setSum(existsMetricValue.getSum() + duplicateMetricValue.getSum());
                existsMetricValue.setCount(existsMetricValue.getCount() + duplicateMetricValue.getCount());
                existsMetricValue.setMin(Math.min(existsMetricValue.getMin(), duplicateMetricValue.getMin()));
                existsMetricValue.setMax(Math.max(existsMetricValue.getMax(), duplicateMetricValue.getMax()));
                break;
            }
            case SUM: {
                long sum = existsMetricValue.getSum() + duplicateMetricValue.getSum();
                existsMetricValue.setSum(sum);
                existsMetricValue.setMax(sum);
                existsMetricValue.setMin(sum);
                existsMetricValue.setCurrent(sum);
                existsMetricValue.setCount(1L);
                break;
            }
            default: {
                logger.warn("The value[" + existsMetricValue.getCurrent() + "] for metric [" + exists.getMetricIdentifier().getName() + "], id[" + exists.getMetricIdentifier().getId() + "]of type [" + (Object)((Object)exists.getMetricIdentifier().getMetricAggregatorType()) + "] may not be the most current value.");
            }
        }
    }

    public String toString() {
        return "RawMetrics{registeredMetrics=" + ArrayUtils.arrayFriendlyToString((Object)this.registeredMetrics) + ", unregisteredMetrics=" + ArrayUtils.arrayFriendlyToString((Object)this.unregisteredMetrics) + '}';
    }
}

