/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles.APercentileAlgorithm;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles.RangeComparator;
import com.singularity.ee.agent.util.MathUtils;
import com.singularity.ee.agent.util.collection.hppc.LongArrayList;
import com.singularity.ee.agent.util.collection.hppc.LongCollection;
import com.singularity.ee.agent.util.collection.hppc.LongCursor;
import com.singularity.ee.agent.util.collection.hppc.LongLongCursor;
import com.singularity.ee.agent.util.collection.hppc.LongLongOpenHashMap;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.ArrayUtilsHelper;
import com.singularity.ee.util.collections.CollectionHelper;
import com.singularity.ee.util.javaspecific.atomic.AgentVolatileLongImpl;
import com.singularity.ee.util.javaspecific.collections.ADIterator;
import com.singularity.ee.util.logging.ILogger;
import com.singularity.ee.util.math.LongUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class QuantileDigestAlgorithm
extends APercentileAlgorithm {
    private static final long INIT_HEIGHT = 8L;
    private long height = 8L;
    public static final AgentVolatileLongImpl compressionFactor = new AgentVolatileLongImpl(1000L);
    private LongLongOpenHashMap node2count = new LongLongOpenHashMap();
    private long CURRENT_MAX_SUPPORTED_VALUE = QuantileDigestAlgorithm.calculateCurrentMaxSupportedValue(8L);
    private long nodeIdOfFirstLeaf = QuantileDigestAlgorithm.calculateNodeIdOfFirstLeaf(8L);
    private static RangeComparator rangeComparator = new RangeComparator();
    private final LongArrayList _dataForDebug = new LongArrayList();

    public QuantileDigestAlgorithm(double[] percentiles, ILogger loggerForPercentileDebug) {
        super(percentiles, loggerForPercentileDebug);
    }

    private void logDebugData(long reportedPercentile, long reportedMin, long reportedMax, long[] rawData) {
        double[] _data = new double[rawData.length];
        for (int i = 0; i < rawData.length; ++i) {
            _data[i] = rawData[i];
        }
        double actual = this.evaluate(_data, 0, _data.length, this.percentiles[0] * 100.0);
        this.logger.debug("-------------------------------------------------------------------------\n");
        this.logger.debug(ArrayUtils.arrayFriendlyToString((Object)_data));
        this.logger.debug("-------------------------------------------------------------------------\n");
        this.logger.debug("Method Option 2");
        this.logger.debug("Count = " + _data.length);
        this.logger.debug("Actual Percentile [" + this.percentiles[0] + "] = " + Math.round(actual));
        this.logger.debug("Reported Percentile [" + this.percentiles[0] + "] = " + reportedPercentile);
        this.logger.debug("Actual Min = " + this.min(_data));
        this.logger.debug("Reported Min = " + reportedMin);
        this.logger.debug("Actual Max = " + this.max(_data));
        this.logger.debug("Reported Max = " + reportedMax);
        this.logger.debug("-------------------------------------------------------------------------\n");
    }

    private double min(double[] data) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        return min;
    }

    private double max(double[] data) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    public double evaluate(double[] values, int begin, int length, double p) {
        if (p > 100.0 || p <= 0.0) {
            throw new IllegalArgumentException("invalid quantile value: " + p);
        }
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double n = length;
        double pos = p * (n + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted = new double[length];
        System.arraycopy(values, begin, sorted, 0, length);
        ArrayUtilsHelper.sort((double[])sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= n) {
            return sorted[length - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _report(long value) {
        QuantileDigestAlgorithm quantileDigestAlgorithm = this;
        synchronized (quantileDigestAlgorithm) {
            ++this.count;
            if (this.count == 1) {
                this._min = value;
                this._max = value;
            } else {
                this._min = value < this._min ? value : this._min;
                long l = this._max = value > this._max ? value : this._max;
            }
            if (value > this.CURRENT_MAX_SUPPORTED_VALUE) {
                this.expandTree(value);
            }
            long leaf = this.getNodeIdOfLeafForValue(value);
            this.node2count.put(leaf, this.getCountForNodeId(leaf) + 1L);
            this.compressUpward(leaf);
            if ((long)this.node2count.Size() > 3L * compressionFactor.get()) {
                this.compress();
            }
            if (this.logger.isDebugEnabled()) {
                this._dataForDebug.add(value);
            }
        }
    }

    private void init() {
        this.count = 0;
        this._max = 0L;
        this._min = 0L;
        this.node2count.clear();
    }

    private static long calculateCurrentMaxSupportedValue(long height) {
        return MathUtils.powBaseTwo(height - 1L) - 1L;
    }

    private long calculateNewHeight(long value) {
        return 63 - LongUtils.numberOfLeadingZeros((long)(LongUtils.highestOneBit((long)value) << 1)) + 1;
    }

    private long getNodeIdOfLeafForValue(long value) {
        return this.nodeIdOfFirstLeaf + value;
    }

    private long getValueForLeafNodeId(long nodeId) {
        return nodeId - this.nodeIdOfFirstLeaf;
    }

    private static long calculateNodeIdOfFirstLeaf(long height) {
        return MathUtils.powBaseTwo(height - 1L);
    }

    private boolean isRoot(long nodeId) {
        return nodeId == 1L;
    }

    private boolean isLeaf(long nodeId) {
        return nodeId >= this.nodeIdOfFirstLeaf;
    }

    private long getSibling(long nodeId) {
        return nodeId % 2L == 0L ? nodeId + 1L : nodeId - 1L;
    }

    private long getParent(long nodeId) {
        return nodeId / 2L;
    }

    private long getLeftChild(long nodeId) {
        return 2L * nodeId;
    }

    private long getRightChild(long nodeId) {
        return 2L * nodeId + 1L;
    }

    private long min(long nodeId) {
        while (!this.isLeaf(nodeId)) {
            nodeId = this.getLeftChild(nodeId);
        }
        return this.getValueForLeafNodeId(nodeId);
    }

    private long max(long nodeId) {
        while (!this.isLeaf(nodeId)) {
            nodeId = this.getRightChild(nodeId);
        }
        return this.getValueForLeafNodeId(nodeId);
    }

    @Override
    protected void reinit(double[] percentiles) {
        this.init();
    }

    private void expandTree(long value) {
        long newHeight = this.calculateNewHeight(value);
        LongLongOpenHashMap newNode2count = new LongLongOpenHashMap();
        long heightFactor = MathUtils.powBaseTwo(newHeight - this.height) - 1L;
        long[] keys = this.node2count.keys().ToArray();
        ArrayUtilsHelper.sort((long[])keys);
        long levelFactor = 1L;
        for (long k : keys) {
            while (levelFactor <= k / 2L) {
                levelFactor <<= 1;
            }
            newNode2count.put(k + levelFactor * heightFactor, this.node2count.get(k));
        }
        this.node2count = newNode2count;
        this.height = newHeight;
        this.CURRENT_MAX_SUPPORTED_VALUE = QuantileDigestAlgorithm.calculateCurrentMaxSupportedValue(this.height);
        this.nodeIdOfFirstLeaf = QuantileDigestAlgorithm.calculateNodeIdOfFirstLeaf(this.height);
        this.compress();
    }

    private void compress() {
        LongCollection keysContainer = this.node2count.keys();
        ADIterator it = new ADIterator((Iterable)keysContainer);
        while (it.hasNext()) {
            long node = ((LongCursor)it.next()).value;
            this.compressNode(node);
        }
    }

    private void compressUpward(long currentNodeId) {
        long parentNodeId;
        long countAtParent;
        long siblingNodeId;
        long countAtSibling;
        double threshold = Math.floor((long)this.count / compressionFactor.get());
        long countAtCurrentNode = this.getCountForNodeId(currentNodeId);
        while (!this.isRoot(currentNodeId) && !((double)(countAtCurrentNode + (countAtSibling = this.getCountForNodeId(siblingNodeId = this.getSibling(currentNodeId))) + (countAtParent = this.getCountForNodeId(parentNodeId = this.getParent(currentNodeId)))) > threshold)) {
            this.node2count.put(parentNodeId, countAtParent + countAtCurrentNode + countAtSibling);
            this.node2count.remove(currentNodeId);
            this.node2count.remove(siblingNodeId);
            currentNodeId = parentNodeId;
            countAtCurrentNode = countAtParent + countAtCurrentNode + countAtSibling;
        }
    }

    private void compressNode(long currentNodeId) {
        double threshold = Math.floor((long)this.count / compressionFactor.get());
        long countAtCurrentNode = this.getCountForNodeId(currentNodeId);
        long siblingNodeId = this.getSibling(currentNodeId);
        long countAtSiblingNode = this.getCountForNodeId(siblingNodeId);
        long parentNodeId = this.getParent(currentNodeId);
        long countAtParentNode = this.getCountForNodeId(parentNodeId);
        if ((double)(countAtParentNode + countAtCurrentNode + countAtSiblingNode) < threshold) {
            this.node2count.put(parentNodeId, countAtParentNode + countAtCurrentNode + countAtSiblingNode);
            this.node2count.remove(currentNodeId);
            this.node2count.remove(siblingNodeId);
        }
    }

    private long getCountForNodeId(long nodeId) {
        return this.node2count.get(nodeId);
    }

    @Override
    protected long getPercentile(double percentile) {
        if (this.count == 0) {
            return 0L;
        }
        List<long[]> ranges = this.postOrder();
        long s = 0L;
        for (long[] r : ranges) {
            if (!((double)(s += r[2]) > percentile * (double)this.count)) continue;
            return r[1];
        }
        return ranges.get(ranges.size() - 1)[1];
    }

    public double getEPS() {
        return this.CURRENT_MAX_SUPPORTED_VALUE / compressionFactor.get();
    }

    private List<long[]> postOrder() {
        ArrayList<long[]> ranges = new ArrayList<long[]>();
        ADIterator cursor = new ADIterator((Iterable)this.node2count);
        while (cursor.hasNext()) {
            LongLongCursor entry = (LongLongCursor)cursor.next();
            ranges.add(new long[]{this.min(entry.key), this.max(entry.key), entry.value});
        }
        CollectionHelper.sort(ranges, (Comparator)rangeComparator);
        return ranges;
    }
}

