/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricListener;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles.APercentileAlgorithm;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;

public class IndividualPercentileAggregator
implements IMetricAggregator {
    private final APercentileAlgorithm algorithm;
    private final int index;
    private boolean changed;

    public IndividualPercentileAggregator(double percentile, int index, APercentileAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.index = index;
    }

    @Override
    public RawMetricValue aggregate() {
        this.setAsUnchanged();
        return this.algorithm.aggregate(this.index);
    }

    @Override
    public boolean isChanged() {
        return this.changed;
    }

    @Override
    public long getLastAggregatedValue() {
        return this.algorithm.getLastAggregatedValue(this.index);
    }

    @Override
    public void resetLastAggregateValue() {
        this.algorithm.resetLastAggregatedValue(this.index);
    }

    @Override
    public void flushMetricsForCurrentThread() {
    }

    @Override
    public void setMetricListener(IMetricListener metricListener) {
    }

    @Override
    public void report(long value) {
        throw new IllegalStateException("The aggregator cannot be reported on. Use APercentileMetricAggregator");
    }

    @Override
    public void report(long value, long count, long min, long max) {
        this.report(value);
    }

    @Override
    public void report(long value, boolean backgroundOK) {
        this.report(value);
    }

    @Override
    public void reportBypassBackgroundProcessing(long value) {
        this.report(value);
    }

    @Override
    public MetricAggregatorType getType() {
        return MetricAggregatorType.PERCENTILE;
    }

    public void setChanged() {
        if (!this.changed) {
            this.changed = true;
        }
    }

    public void setAsUnchanged() {
        if (this.changed) {
            this.changed = false;
        }
    }
}

