/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles.APercentileAlgorithm;
import com.singularity.ee.util.collections.ArrayUtils;
import com.singularity.ee.util.collections.ArrayUtilsHelper;
import com.singularity.ee.util.logging.ILogger;

public class ExtendedPSquareAlgorithm
extends APercentileAlgorithm {
    private int marker_count;
    private double[] marker_heights;
    private double[] increment_in_desired_marker_positions;
    private double[] desired_marker_positions;
    private int[] marker_positions;

    public ExtendedPSquareAlgorithm(double[] percentiles, ILogger _logger) {
        super(percentiles, _logger);
        this.reinit(percentiles);
    }

    private void logDebugData(long reportedPercentile, long reportedMin, long reportedMax, long[] rawData) {
        double[] _data = new double[rawData.length];
        for (int i = 0; i < rawData.length; ++i) {
            _data[i] = rawData[i];
        }
        double actual = this.evaluate(_data, 0, _data.length, this.percentiles[0] * 100.0);
        this.logger.debug("-------------------------------------------------------------------------\n");
        this.logger.debug(ArrayUtils.arrayFriendlyToString((Object)_data));
        this.logger.debug("-------------------------------------------------------------------------\n");
        this.logger.debug("Method Option 1");
        this.logger.debug("Count = " + _data.length);
        this.logger.debug("Actual Percentile [" + this.percentiles[0] + "] = " + Math.round(actual));
        this.logger.debug("Reported Percentile [" + this.percentiles[0] + "] = " + reportedPercentile);
        this.logger.debug("Actual Min = " + this.min(_data));
        this.logger.debug("Reported Min = " + reportedMin);
        this.logger.debug("Actual Max = " + this.max(_data));
        this.logger.debug("Reported Max = " + reportedMax);
        this.logger.debug("-------------------------------------------------------------------------\n");
    }

    private double min(double[] data) {
        double min = Double.MAX_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] < min)) continue;
            min = data[i];
        }
        return min;
    }

    private double max(double[] data) {
        double max = Double.MIN_VALUE;
        for (int i = 0; i < data.length; ++i) {
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        return max;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _report(long data) {
        int k = -1;
        ExtendedPSquareAlgorithm extendedPSquareAlgorithm = this;
        synchronized (extendedPSquareAlgorithm) {
            if (this.count >= this.marker_count) {
                int i;
                ++this.count;
                if ((double)data < this.marker_heights[0]) {
                    this.marker_heights[0] = data;
                    k = 1;
                } else if ((double)data >= this.marker_heights[this.marker_count - 1]) {
                    this.marker_heights[this.marker_count - 1] = data;
                    k = this.marker_count - 1;
                } else {
                    for (i = 1; i < this.marker_count; ++i) {
                        if (!((double)data < this.marker_heights[i])) continue;
                        k = i;
                        break;
                    }
                }
                for (i = k; i < this.marker_count; ++i) {
                    int n = i;
                    this.marker_positions[n] = this.marker_positions[n] + 1;
                    this.desired_marker_positions[i] = this.desired_marker_positions[i] + this.increment_in_desired_marker_positions[i];
                }
                for (i = 0; i < k; ++i) {
                    this.desired_marker_positions[i] = this.desired_marker_positions[i] + this.increment_in_desired_marker_positions[i];
                }
                for (i = 1; i < this.marker_count - 1; ++i) {
                    double d = this.desired_marker_positions[i] - (double)this.marker_positions[i];
                    if (!(d >= 1.0 && this.marker_positions[i + 1] - this.marker_positions[i] > 1) && (!(d <= -1.0) || !((double)(this.marker_positions[i - 1] - this.marker_positions[i]) < -1.0))) continue;
                    double newq = this.use_parabolic_interpolation(i, this.sign(d));
                    this.marker_heights[i] = this.marker_heights[i - 1] < newq && newq < this.marker_heights[i + 1] ? newq : this.use_linear_interpolation(i, this.sign(d));
                    int n = i;
                    this.marker_positions[n] = this.marker_positions[n] + this.sign(d);
                }
            } else {
                this.marker_heights[this.count] = data;
                ++this.count;
                if (this.count == this.marker_count) {
                    ArrayUtilsHelper.sort((double[])this.marker_heights);
                    for (int i = 0; i < this.marker_count; ++i) {
                        this.marker_positions[i] = i + 1;
                    }
                }
            }
            if (this.count == 1) {
                this._min = data;
                this._max = data;
            } else {
                this._min = data < this._min ? data : this._min;
                this._max = data > this._max ? data : this._max;
            }
        }
    }

    @Override
    protected long getPercentile(double percentile) {
        if (this.count < this.marker_count) {
            if (this.count == 0) {
                return 0L;
            }
            ArrayUtilsHelper.sort((double[])this.marker_heights, (int)0, (int)this.count);
            if (this.count == 1) {
                return (long)this.marker_heights[0];
            }
            double pos = percentile * (double)(this.count + 1);
            double fpos = Math.floor(pos);
            int intPos = (int)fpos;
            double dif = pos - fpos;
            if (pos < 1.0) {
                return (long)this.marker_heights[0];
            }
            if (pos >= (double)this.count) {
                return (long)this.marker_heights[this.count - 1];
            }
            double lower = this.marker_heights[intPos - 1];
            double upper = this.marker_heights[intPos];
            return (long)(lower + dif * (upper - lower));
        }
        int closest = 1;
        for (int i = 2; i < this.marker_count - 1; ++i) {
            if (!(Math.abs(this.increment_in_desired_marker_positions[i] - percentile) < Math.abs(this.increment_in_desired_marker_positions[closest] - percentile))) continue;
            closest = i;
        }
        return (long)this.marker_heights[closest];
    }

    @Override
    protected void reinit(double[] percentiles) {
        int i;
        this.count = 0;
        this._min = 0L;
        this._max = 0L;
        this.marker_count = 3 * percentiles.length + 2;
        this.marker_heights = new double[this.marker_count];
        this.increment_in_desired_marker_positions = new double[this.marker_count];
        this.desired_marker_positions = new double[this.marker_count];
        this.marker_positions = new int[this.marker_count];
        int j = 0;
        for (i = 0; i < percentiles.length; ++i) {
            this.increment_in_desired_marker_positions[j++] = percentiles[i];
            this.increment_in_desired_marker_positions[j++] = percentiles[i] / 2.0;
            this.increment_in_desired_marker_positions[j++] = (percentiles[i] + 1.0) / 2.0;
        }
        this.increment_in_desired_marker_positions[j++] = 0.0;
        this.increment_in_desired_marker_positions[j] = 1.0;
        ArrayUtilsHelper.sort((double[])this.increment_in_desired_marker_positions);
        for (i = 0; i < this.marker_count; ++i) {
            this.desired_marker_positions[i] = (double)(this.marker_count - 1) * this.increment_in_desired_marker_positions[i] + 1.0;
        }
    }

    private int sign(double d) {
        if (d >= 0.0) {
            return 1;
        }
        return -1;
    }

    private double use_parabolic_interpolation(int i, int d) {
        return this.marker_heights[i] + (double)d / (double)(this.marker_positions[i + 1] - this.marker_positions[i - 1]) * ((double)(this.marker_positions[i] - this.marker_positions[i - 1] + d) * (this.marker_heights[i + 1] - this.marker_heights[i]) / (double)(this.marker_positions[i + 1] - this.marker_positions[i]) + (double)(this.marker_positions[i + 1] - this.marker_positions[i] - d) * (this.marker_heights[i] - this.marker_heights[i - 1]) / (double)(this.marker_positions[i] - this.marker_positions[i - 1]));
    }

    private double use_linear_interpolation(int i, int d) {
        return this.marker_heights[i] + (double)d * (this.marker_heights[i + d] - this.marker_heights[i]) / (double)(this.marker_positions[i + d] - this.marker_positions[i]);
    }

    private double evaluate(double[] values, int begin, int length, double p) {
        if (length == 0) {
            return Double.NaN;
        }
        if (length == 1) {
            return values[begin];
        }
        double n = length;
        double pos = p * (n + 1.0) / 100.0;
        double fpos = Math.floor(pos);
        int intPos = (int)fpos;
        double dif = pos - fpos;
        double[] sorted = new double[length];
        System.arraycopy(values, begin, sorted, 0, length);
        ArrayUtilsHelper.sort((double[])sorted);
        if (pos < 1.0) {
            return sorted[0];
        }
        if (pos >= n) {
            return sorted[length - 1];
        }
        double lower = sorted[intPos - 1];
        double upper = sorted[intPos];
        return lower + dif * (upper - lower);
    }
}

