/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.percentiles.IndividualPercentileAggregator;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.clock.ClockUtils;
import com.singularity.ee.util.logging.ILogger;

public abstract class APercentileAlgorithm {
    protected final ILogger logger;
    protected final double[] percentiles;
    protected int count;
    protected long _min;
    protected long _max;
    private boolean changed;
    private RawMetricValue[] cache;
    private long lastAggregationTimeMs;
    private final IndividualPercentileAggregator[] individualPercentileAggregators;

    public APercentileAlgorithm(double[] percentiles, ILogger _logger) {
        this.percentiles = percentiles;
        this.logger = _logger;
        this.individualPercentileAggregators = new IndividualPercentileAggregator[this.percentiles.length];
        for (int i = 0; i < percentiles.length; ++i) {
            double percentile = percentiles[i];
            this.individualPercentileAggregators[i] = new IndividualPercentileAggregator(percentile, i, this);
        }
    }

    public synchronized RawMetricValue aggregate(int index) {
        if (ClockUtils.getCurrentTime() - this.lastAggregationTimeMs > 10000L || this.cache == null || this.cache[index] == null) {
            this.lastAggregationTimeMs = ClockUtils.getCurrentTime();
            this.cache = this.aggregateAll();
        }
        return this.cache[index];
    }

    public IMetricAggregator getIndividualPercentileAggregator(int index) {
        return this.individualPercentileAggregators[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final RawMetricValue[] aggregateAll() {
        int i;
        long max;
        long min;
        long count;
        long[] current = new long[this.percentiles.length];
        APercentileAlgorithm aPercentileAlgorithm = this;
        synchronized (aPercentileAlgorithm) {
            count = this.count;
            min = this._min;
            max = this._max;
            for (i = 0; i < this.percentiles.length; ++i) {
                current[i] = this.getPercentile(this.percentiles[i]);
            }
            this.reinit(this.percentiles);
        }
        RawMetricValue[] metricValues = new RawMetricValue[this.percentiles.length];
        for (i = 0; i < this.percentiles.length; ++i) {
            metricValues[i] = new RawMetricValue();
            metricValues[i].setCurrent(current[i]);
            metricValues[i].setMax(max);
            metricValues[i].setMin(min);
            metricValues[i].setCount(count);
            metricValues[i].setSum(current[i] * count);
        }
        this.setAsUnChanged();
        return metricValues;
    }

    public void report(long value) {
        this.setChanged();
        this._report(value);
    }

    public void setChanged() {
        if (!this.changed) {
            this.changed = true;
            for (int i = 0; i < this.individualPercentileAggregators.length; ++i) {
                this.individualPercentileAggregators[i].setChanged();
            }
        }
    }

    public void setAsUnChanged() {
        if (this.changed) {
            this.changed = false;
        }
    }

    protected abstract void _report(long var1);

    protected abstract long getPercentile(double var1);

    protected abstract void reinit(double[] var1);

    public long getLastAggregatedValue(int index) {
        if (this.cache != null && this.cache[index] != null) {
            return this.cache[index].getCurrent();
        }
        return -1L;
    }

    public void resetLastAggregatedValue(int index) {
        this.cache[index] = null;
    }
}

