/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.spi.IAgentAtomicLong;

public final class SumMetricAggregator
extends AMetricAggregator {
    private final IAgentAtomicLong sum = new AgentAtomicLongImpl(0L);
    private final IAgentAtomicLong lastAggregatedValue = new AgentAtomicLongImpl(0L);

    @Override
    public MetricAggregatorType getType() {
        return MetricAggregatorType.SUM;
    }

    @Override
    protected void _report(long value) {
        this.setAsChanged();
        this.sum.addAndGet(value);
    }

    public long getCurrentSum() {
        return this.sum.get();
    }

    @Override
    public long getLastAggregatedValue() {
        return this.lastAggregatedValue.get();
    }

    @Override
    public void resetLastAggregateValue() {
        this.lastAggregatedValue.set(0L);
    }

    @Override
    public RawMetricValue aggregate() {
        this.setAsUnchanged();
        long sum = this.sum.getAndSet(0L);
        this.lastAggregatedValue.set(sum);
        RawMetricValue val = new RawMetricValue();
        val.setSum(sum);
        val.setCurrent(sum);
        val.setMax(sum);
        val.setMin(sum);
        val.setCount(1L);
        return val;
    }
}

