/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.spi.IAgentAtomicLong;

public final class ObservationForeverIncreasingMetricAggregator
extends AMetricAggregator {
    private long deltaValue;
    private long lastReportedValue;
    private boolean firstTime = true;
    private final IAgentAtomicLong lastAggregatedValue = new AgentAtomicLongImpl(0L);
    private final Object aggregatorLock = new Object();

    @Override
    public MetricAggregatorType getType() {
        return MetricAggregatorType.OBSERVATION_FOREVERINCREASING;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _report(long value) {
        Object object = this.aggregatorLock;
        synchronized (object) {
            if (this.firstTime) {
                this.firstTime = false;
                this.lastReportedValue = value;
            } else if (value < this.lastReportedValue) {
                this.lastReportedValue = value;
                this.deltaValue = 0L;
                this.setAsUnchanged();
            } else {
                this.deltaValue = value - this.lastReportedValue;
                this.lastReportedValue = value;
                this.setAsChanged();
            }
        }
    }

    @Override
    public long getLastAggregatedValue() {
        return this.lastAggregatedValue.get();
    }

    @Override
    public void resetLastAggregateValue() {
        this.lastAggregatedValue.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawMetricValue aggregate() {
        long value;
        Object object = this.aggregatorLock;
        synchronized (object) {
            this.setAsUnchanged();
            value = this.deltaValue;
        }
        this.lastAggregatedValue.set(value);
        RawMetricValue val = new RawMetricValue();
        val.setSum(value);
        val.setCurrent(value);
        val.setMax(value);
        val.setMin(value);
        val.setCount(1L);
        return val;
    }

    @Override
    public void resetReportedIntervals() {
        this.firstTime = true;
        super.resetReportedIntervals();
    }
}

