/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.spi.IAgentAtomicLong;

public final class AverageMetricAggregator
extends AMetricAggregator {
    private long count;
    private long sum;
    private long min = Long.MAX_VALUE;
    private long max;
    private long current;
    private final IAgentAtomicLong lastAggregatedValue = new AgentAtomicLongImpl(0L);

    @Override
    public MetricAggregatorType getType() {
        return MetricAggregatorType.AVERAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _report(long value) {
        this.setAsChanged();
        AverageMetricAggregator averageMetricAggregator = this;
        synchronized (averageMetricAggregator) {
            ++this.count;
            this.sum += value;
        }
        this.min = value < this.min ? value : this.min;
        this.max = value > this.max ? value : this.max;
        this.current = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(long value, long aCount, long aMin, long aMax) {
        this.setAsChanged();
        AverageMetricAggregator averageMetricAggregator = this;
        synchronized (averageMetricAggregator) {
            this.count += aCount;
            this.sum += value;
        }
        this.current = value;
        this.min = aMin < this.min ? aMin : this.min;
        this.max = aMax > this.max ? aMax : this.max;
    }

    @Override
    public long getLastAggregatedValue() {
        return this.lastAggregatedValue.get();
    }

    @Override
    public void resetLastAggregateValue() {
        this.lastAggregatedValue.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawMetricValue aggregate() {
        long current;
        long max;
        long min;
        long sum;
        long count;
        AverageMetricAggregator averageMetricAggregator = this;
        synchronized (averageMetricAggregator) {
            this.setAsUnchanged();
            count = this.count;
            sum = this.sum;
            min = this.min == Long.MAX_VALUE ? 0L : this.min;
            max = this.max;
            current = this.current;
            this.count = 0L;
            this.sum = 0L;
            this.min = Long.MAX_VALUE;
            this.max = 0L;
            this.current = 0L;
        }
        long avgValue = count == 0L ? 0L : sum / count;
        this.lastAggregatedValue.set(avgValue);
        RawMetricValue val = new RawMetricValue();
        val.setSum(sum);
        val.setCurrent(current);
        val.setMax(max);
        val.setMin(min == Long.MAX_VALUE ? 0L : min);
        val.setCount(count);
        return val;
    }
}

