/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.AMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicIntegerImpl;
import com.singularity.ee.util.javaspecific.atomic.AgentAtomicLongImpl;
import com.singularity.ee.util.spi.IAgentAtomicInteger;
import com.singularity.ee.util.spi.IAgentAtomicLong;

public class AdvancedAverageMetricAggregator
extends AMetricAggregator {
    private long count;
    private long sum;
    private long min;
    private long max;
    private long current;
    private final IAgentAtomicLong lastAggregatedValue = new AgentAtomicLongImpl(0L);
    private final Object aggregatorLock = new Object();
    private float emaAlpha;
    private volatile float emaValue;
    private volatile int emaCount;
    private volatile float emaStdDevValue;
    private volatile float stdMean = 0.0f;
    private float stdM2 = 0.0f;
    private final IAgentAtomicInteger movingAvgDurationMins = new AgentAtomicIntegerImpl();

    @Override
    public MetricAggregatorType getType() {
        return MetricAggregatorType.ADVANCED_AVERAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _report(long value) {
        Object object = this.aggregatorLock;
        synchronized (object) {
            this.setAsChanged();
            ++this.count;
            if (this.count == 1L) {
                this.min = value;
                this.max = value;
            } else {
                this.min = value < this.min ? value : this.min;
                this.max = value > this.max ? value : this.max;
            }
            this.sum += value;
            this.current = value;
            float delta = (float)value - this.stdMean;
            this.stdMean += delta / (float)this.count;
            this.stdM2 += delta * ((float)value - this.stdMean);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void report(long value, long aCount, long aMin, long aMax) {
        Object object = this.aggregatorLock;
        synchronized (object) {
            this.setAsChanged();
            if (this.count == 0L) {
                this.min = aMin;
                this.max = aMax;
            } else {
                this.min = aMin < this.min ? aMin : this.min;
                this.max = aMax > this.max ? aMax : this.max;
            }
            this.count += aCount;
            this.sum += value;
            this.current = value;
            float delta = (float)value - this.stdMean;
            this.stdMean += delta / (float)this.count;
            this.stdM2 += delta * ((float)value - this.stdMean);
        }
    }

    @Override
    public long getLastAggregatedValue() {
        return this.lastAggregatedValue.get();
    }

    @Override
    public void resetLastAggregateValue() {
        this.lastAggregatedValue.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawMetricValue aggregate() {
        long current;
        long max;
        long min;
        long sum;
        long count;
        float stdM2 = 0.0f;
        Object object = this.aggregatorLock;
        synchronized (object) {
            this.setAsUnchanged();
            count = this.count;
            sum = this.sum;
            min = this.min;
            max = this.max;
            current = this.current;
            this.count = 0L;
            this.sum = 0L;
            this.min = 0L;
            this.max = 0L;
            this.current = 0L;
            stdM2 = this.stdM2;
            this.stdMean = 0.0f;
            this.stdM2 = 0.0f;
        }
        long avgValue = count == 0L ? 0L : sum / count;
        this.lastAggregatedValue.set(avgValue);
        if (count > 1L) {
            float stdDev = (float)Math.sqrt(stdM2 / (float)(count - 1L));
            this.updateMovingAverage(avgValue, stdDev);
        }
        RawMetricValue val = new RawMetricValue();
        val.setSum(sum);
        val.setCurrent(current);
        val.setMax(max);
        val.setMin(min);
        val.setCount(count);
        return val;
    }

    private void updateMovingAverage(float newAvgValue, float newStdDev) {
        if (this.emaCount < 10) {
            this.emaValue = (newAvgValue + this.emaValue * (float)this.emaCount) / (float)(this.emaCount + 1);
            this.emaStdDevValue = (newStdDev + this.emaStdDevValue * (float)this.emaCount) / (float)(this.emaCount + 1);
        } else {
            this.emaValue = this.emaAlpha * newAvgValue + (1.0f - this.emaAlpha) * this.emaValue;
            this.emaStdDevValue = this.emaAlpha * newStdDev + (1.0f - this.emaAlpha) * this.emaStdDevValue;
        }
        ++this.emaCount;
    }

    public boolean isMovingAverageReady() {
        return this.emaCount > 30;
    }

    public int hasDataForMins() {
        return this.emaCount;
    }

    public void setMovingAverageDuration(int durationInMinutes) {
        if (durationInMinutes < 30) {
            durationInMinutes = 30;
        }
        this.movingAvgDurationMins.set(durationInMinutes);
        this.emaAlpha = 2.0f / ((float)durationInMinutes + 1.0f);
    }

    public float getMovingStdDev() {
        return this.emaStdDevValue;
    }

    public float getMovingAverage() {
        return this.emaValue;
    }

    public int getMovingAvgDurationMins() {
        return this.movingAvgDurationMins.get();
    }
}

