/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.agent.commonservices.metricgeneration.aggregation;

import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.IMetricAggregatorBackgroundTask;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricAggregator;
import com.singularity.ee.agent.commonservices.metricgeneration.aggregation.boot.IMetricListener;
import com.singularity.ee.agent.commonservices.metricgeneration.metrics.spi.MetricAggregatorType;
import com.singularity.ee.controller.api.dto.RawMetricValue;
import com.singularity.ee.util.enums.EnumHelper;
import com.singularity.ee.util.system.SystemUtils;

public abstract class AMetricAggregator
implements IMetricAggregator {
    private static final String ASYNC_METRICS_PROP_NAME = "appdynamics.async.all.metrics";
    private volatile boolean changed = false;
    private int reportedIntervals = 0;
    private static final int warmupIntervals = 5;
    protected static IMetricAggregatorBackgroundTask backgroundTask;
    private IMetricListener metricListener = null;
    private static MetricAsync asyncAllMetrics;

    private static MetricAsync parseMetricAsync(String metricAsyncString) throws IllegalArgumentException {
        MetricAsync returnValue = null;
        if (metricAsyncString != null) {
            returnValue = (MetricAsync)EnumHelper.getEnum(MetricAsync.class, (String)metricAsyncString);
        }
        return returnValue;
    }

    public static void setMetricAsync(String metricAsyncString) throws IllegalArgumentException {
        MetricAsync newMetricAsync = AMetricAggregator.parseMetricAsync(metricAsyncString);
        if (newMetricAsync != null) {
            asyncAllMetrics = newMetricAsync;
        }
    }

    @Override
    public abstract RawMetricValue aggregate();

    @Override
    public abstract long getLastAggregatedValue();

    @Override
    public abstract void resetLastAggregateValue();

    protected abstract void _report(long var1);

    @Override
    public abstract MetricAggregatorType getType();

    @Override
    public void report(long value) {
        IMetricListener listener = this.metricListener;
        if (listener != null) {
            listener.report(value);
        }
        if (asyncAllMetrics == MetricAsync.always && backgroundTask != null) {
            backgroundTask.process(value, this);
        } else {
            this._report(value);
        }
    }

    @Override
    public void reportBypassBackgroundProcessing(long value) {
        this._report(value);
    }

    @Override
    public boolean isChanged() {
        if (this.reportedIntervals < 5) {
            ++this.reportedIntervals;
            return true;
        }
        return this.changed;
    }

    protected void setAsChanged() {
        if (!this.changed) {
            this.changed = true;
        }
    }

    protected void setAsUnchanged() {
        this.changed = false;
    }

    public static void setMetricAggregatorBackgroundTask(IMetricAggregatorBackgroundTask backgroundTask) {
        AMetricAggregator.backgroundTask = backgroundTask;
    }

    @Override
    public void report(long value, boolean backgroundOK) {
        IMetricListener listener = this.metricListener;
        if (listener != null) {
            listener.report(value);
        }
        if ((asyncAllMetrics == MetricAsync.always || asyncAllMetrics == MetricAsync.sometimes && backgroundOK) && backgroundTask != null) {
            backgroundTask.process(value, this);
        } else {
            this._report(value);
        }
    }

    @Override
    public void report(long value, long count, long min, long max) {
        throw new UnsupportedOperationException("Only AverageMetricAggregator and AdvancedAverageMetricAggregator supports this method. Please use report(long value) instead.");
    }

    @Override
    public void flushMetricsForCurrentThread() {
        if (backgroundTask != null && asyncAllMetrics != MetricAsync.never) {
            backgroundTask.flushForCurrentThread();
        }
    }

    @Override
    public void setMetricListener(IMetricListener metricListener) {
        this.metricListener = metricListener;
    }

    public void resetReportedIntervals() {
        this.reportedIntervals = 0;
    }

    static {
        String asyncString = SystemUtils.getProperty((String)ASYNC_METRICS_PROP_NAME);
        try {
            asyncAllMetrics = AMetricAggregator.parseMetricAsync(asyncString);
        }
        catch (IllegalArgumentException e) {
            asyncAllMetrics = null;
        }
        if (asyncAllMetrics == null) {
            asyncAllMetrics = MetricAsync.never;
        }
    }

    private static enum MetricAsync {
        always,
        never,
        sometimes;

    }
}

