/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.queue;

import com.appdynamics.analytics.message.MessageSources;
import com.appdynamics.analytics.queue.QueueConfiguration;
import com.appdynamics.analytics.queue.QueueSource;
import com.appdynamics.analytics.queue.Queues;
import com.appdynamics.analytics.queue.QueuesModuleConfiguration;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.health.QueueCapacityHealthCheck;
import com.google.common.base.Suppliers;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueuesModule
extends Module<QueuesModuleConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueuesModule.class);

    @Provides
    @Singleton
    public Queues makeQueues(MessageSources messageSources, ConsolidatedHealthCheck healthCheck) {
        Queues queues = new Queues();
        QueuesModuleConfiguration moduleConfiguration = (QueuesModuleConfiguration)this.getConfiguration();
        List<QueueConfiguration> staticQueueConfigurations = moduleConfiguration.getQueues();
        if (!staticQueueConfigurations.isEmpty()) {
            log.debug("Attempting to create [{}] statically defined queues", (Object)staticQueueConfigurations.size());
            for (QueueConfiguration queueConfiguration : staticQueueConfigurations) {
                BlockingQueue queue = queues.findOrSetupQueue(queueConfiguration);
                if (!queueConfiguration.isMessageSource()) continue;
                QueueSource queueSource = new QueueSource(queueConfiguration.getQueueName(), queue);
                messageSources.register((Object)queueConfiguration.getQueueName(), Suppliers.ofInstance(queueSource));
                log.debug("Registered [{}] queue as a message source", (Object)queueConfiguration.getQueueName());
            }
        }
        QueueCapacityHealthCheck capacityHealthCheck = new QueueCapacityHealthCheck(this.getUri(), ((QueuesModuleConfiguration)this.getConfiguration()).getAlertRatio().doubleValue(), queues.getQueues());
        healthCheck.register((HealthCheckable)capacityHealthCheck);
        return queues;
    }
}

