/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.queue;

import com.appdynamics.analytics.message.api.MessagePack;
import com.appdynamics.analytics.message.api.MessageSource;
import com.appdynamics.analytics.message.util.RetriableMessagePack;
import com.appdynamics.common.util.execution.Retriable;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueueSource<ID, MSG>
implements MessageSource<ID, MSG> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(QueueSource.class);
    final ID id;
    final BlockingQueue<MSG> queue;
    final ThreadLocal<OurRetriableMessagePack<ID, MSG>> tlsMessagePacks;

    public QueueSource(final ID id, BlockingQueue<MSG> queue) {
        Preconditions.checkArgument((boolean)Retriable.class.isAssignableFrom(OurRetriableMessagePack.class), (Object)("[" + OurRetriableMessagePack.class.getName() + "] is not [" + Retriable.class.getName() + "]"));
        this.id = id;
        this.queue = queue;
        this.tlsMessagePacks = new ThreadLocal<OurRetriableMessagePack<ID, MSG>>(){

            @Override
            protected OurRetriableMessagePack<ID, MSG> initialValue() {
                return new OurRetriableMessagePack(id, new ArrayDeque());
            }
        };
    }

    public BlockingQueue<MSG> getQueue() {
        return this.queue;
    }

    @Override
    public ID getId() {
        return this.id;
    }

    @Override
    public boolean supportsRetriable() {
        return true;
    }

    @Override
    public MessagePack<ID, MSG> poll(int maxMessages, long callTimeOut, TimeUnit callTimeOutUnit) throws InterruptedException {
        MSG message;
        Object message2;
        RetriableMessagePack.ReturnedMessage rm;
        OurRetriableMessagePack<ID, MSG> messagePack = this.tlsMessagePacks.get();
        Deque returnedMessages = messagePack.getUndeliveredErrorMessages();
        while ((rm = returnedMessages.poll()) != null) {
            log.error("Dropping message [{}] that encountered permanent error: [{}]", rm.getMessage(), (Object)rm.getCause());
        }
        while ((message2 = messagePack.poll()) != null) {
            log.error("Dropping message [{}] due to the fact that the number of transient errors it encountered exceeded the maximum number of configured retries", message2);
        }
        messagePack.resetCounts();
        Deque messages = messagePack.anotherRefToMessages;
        while (maxMessages > 0 && (message = this.queue.poll(callTimeOut, callTimeOutUnit)) != null) {
            boolean ok = messages.offer(message);
            if (ok) {
                --maxMessages;
            }
            if (maxMessages <= 0) continue;
            maxMessages -= this.queue.drainTo(messages, maxMessages);
        }
        return messages.isEmpty() ? null : messagePack;
    }

    @Override
    public void close() throws IOException {
    }

    private static class OurRetriableMessagePack<ID, MSG>
    extends RetriableMessagePack<ID, MSG> {
        final Deque<MSG> anotherRefToMessages;

        OurRetriableMessagePack(ID id, Deque<MSG> messages) {
            super(id, messages);
            this.anotherRefToMessages = messages;
        }
    }
}

