/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.time;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import java.util.Map;

public class DuplicateTimestampCorrectionStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    private String source;
    private long previousTimestamp;
    private long nextAvailableTimestamp;

    DuplicateTimestampCorrectionStage(PipelineStageParameters<Map<String, Object>> parameters, String source) {
        super(parameters);
        this.source = source;
        this.previousTimestamp = 0L;
        this.nextAvailableTimestamp = 0L;
    }

    @Override
    public void process(Map<String, Object> input) {
        long timestamp = (Long)input.get(this.source);
        if (timestamp <= this.nextAvailableTimestamp && timestamp >= this.previousTimestamp) {
            ++this.nextAvailableTimestamp;
            timestamp = this.nextAvailableTimestamp;
            input.put(this.source, timestamp);
        } else {
            this.nextAvailableTimestamp = this.previousTimestamp = timestamp;
        }
        this.invokeNext(input);
    }
}

