/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.text;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.xform.text.AbstractMultilineStage;
import com.appdynamics.analytics.pipeline.xform.text.AbstractMultilineStageFactory;
import com.appdynamics.analytics.pipeline.xform.text.MatchAction;
import com.appdynamics.analytics.pipeline.xform.text.MatchType;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;

public class Multiline2Utf8StageFactory
extends AbstractMultilineStageFactory<ByteBuffer> {
    Multiline2Utf8Stage newMultilineStage(PipelineStageParameters<ByteBuffer> parameters, MatchType matchType, String matchValue, MatchAction matchAction, int bufferSizeWarnAbove) {
        return new Multiline2Utf8Stage(parameters, matchType, matchValue, matchAction, bufferSizeWarnAbove);
    }

    static class Multiline2Utf8Stage
    extends AbstractMultilineStage<ByteBuffer> {
        Multiline2Utf8Stage(PipelineStageParameters<ByteBuffer> parameters, MatchType matchType, String matchValue, MatchAction matchAction, int bufferSizeWarnAbove) {
            super(parameters, matchType, matchValue, matchAction, "\n", bufferSizeWarnAbove);
        }

        @Override
        ByteBuffer extractForNextStage(StringBuilder reusableBuilder) {
            CharBuffer charBuffer = CharBuffer.wrap(reusableBuilder);
            CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
            ByteBuffer output = null;
            try {
                output = encoder.encode(charBuffer);
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException(e);
            }
            reusableBuilder.setLength(0);
            return output;
        }
    }
}

