/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.text;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.xform.text.MatchAction;
import com.appdynamics.analytics.pipeline.xform.text.MatchType;
import com.appdynamics.common.util.configuration.ConfigurationException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractMultilineStage<O>
extends AbstractPipelineStage<CharSequence, O> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractMultilineStage.class);
    final MatchType matchType;
    final String matchValue;
    final MatchAction matchAction;
    final MatchAction noMatchAction;
    final String lineSeparator;
    final int bufferSizeWarnAbove;
    private final Pattern optRegexPattern;
    private final Matcher optReusableMatcher;
    private final StringBuilder reusableBuilder;

    protected AbstractMultilineStage(PipelineStageParameters<O> parameters, MatchType matchType, String matchValue, MatchAction matchAction, String lineSeparator, int bufferSizeWarnAbove) {
        super(parameters);
        this.matchType = matchType;
        this.matchValue = matchValue;
        this.matchAction = matchAction;
        this.noMatchAction = matchAction.inverse();
        this.lineSeparator = lineSeparator;
        this.bufferSizeWarnAbove = bufferSizeWarnAbove;
        this.reusableBuilder = new StringBuilder();
        switch (matchType) {
            case regex: {
                try {
                    this.optRegexPattern = Pattern.compile(matchValue);
                }
                catch (PatternSyntaxException e) {
                    throw new ConfigurationException("Error occurred while applying the regular expression [" + matchValue + "] at [" + this.printableName() + "]", (Throwable)e);
                }
                this.optReusableMatcher = this.optRegexPattern.matcher("");
                break;
            }
            case startsWith: {
                this.optRegexPattern = null;
                this.optReusableMatcher = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized match type [" + String.valueOf((Object)matchType) + "]");
            }
        }
        switch (matchAction) {
            case NEW: 
            case APPEND: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized match action [" + String.valueOf((Object)matchAction) + "]");
            }
        }
    }

    @Override
    public final void process(CharSequence inputChars) {
        MatchAction action = AbstractMultilineStage.attemptMatch(inputChars, this.matchType, this.matchAction, this.noMatchAction, this.matchValue, this.optReusableMatcher);
        if (log.isTraceEnabled()) {
            log.trace("Match attempt on [{}] yielded [{}] action", (Object)inputChars, (Object)action);
        }
        switch (action) {
            case APPEND: {
                if (this.reusableBuilder.length() > 0) {
                    this.reusableBuilder.append(this.lineSeparator);
                }
                this.reusableBuilder.append(inputChars);
                int size = this.reusableBuilder.length();
                if (size <= this.bufferSizeWarnAbove) break;
                log.warn("The [{}] stage appears to have accumulated too many characters [{}]. If this was intentional then consider increasing the threshold, which is currently set to [{}]. First few accumulated characters [{}...]", new Object[]{this.printableName(), size, this.bufferSizeWarnAbove, this.reusableBuilder.substring(0, Math.min(96, size))});
                break;
            }
            case FLUSH: {
                this.flush();
                break;
            }
            case NEW: {
                this.flush();
                this.reusableBuilder.append(inputChars);
                break;
            }
        }
    }

    private void flush() {
        if (this.reusableBuilder.length() > 0) {
            O oldText = this.extractForNextStage(this.reusableBuilder);
            this.invokeNext(oldText);
        }
    }

    abstract O extractForNextStage(StringBuilder var1);

    static MatchAction attemptMatch(CharSequence inputChars, MatchType matchType, MatchAction matchAction, MatchAction noMatchAction, String matchValue, Matcher optReusableMatcher) {
        if (inputChars == null) {
            return MatchAction.FLUSH;
        }
        MatchAction action = noMatchAction;
        switch (matchType) {
            case regex: {
                optReusableMatcher.reset(inputChars);
                if (optReusableMatcher.matches()) {
                    action = matchAction;
                }
                optReusableMatcher.reset();
                break;
            }
            case startsWith: {
                int j;
                int o;
                if (inputChars instanceof String) {
                    if (!((String)inputChars).startsWith(matchValue)) break;
                    action = matchAction;
                    break;
                }
                int i = inputChars.length();
                if (i < (o = matchValue.length())) break;
                for (j = 0; j < o && inputChars.charAt(j) == matchValue.charAt(j); ++j) {
                }
                if (j != o) break;
                action = matchAction;
            }
        }
        return action;
    }
}

