/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.keyvalue;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.util.FieldValueHelper;
import com.appdynamics.analytics.pipeline.xform.keyvalue.LogFieldMetadata;
import com.appdynamics.analytics.pipeline.xform.map.PositionalFieldInfo;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KeyValueStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KeyValueStage.class);
    final String message;
    final List<String> separators;
    final List<String> splits;
    final List<String> source;
    final List<String> trim;
    final List<String> include;
    final Map<String, LogFieldMetadata> keyToFieldMap;
    final String separatorRegex;

    public KeyValueStage(PipelineStageParameters<Map<String, Object>> parameters, String message, List<String> source, List<String> separators, List<String> split, List<String> trim, List<String> include, Map<String, LogFieldMetadata> keyToFieldMap) {
        super(parameters);
        this.message = message;
        this.source = source;
        this.separators = separators;
        this.splits = split;
        this.trim = trim;
        this.include = include;
        this.keyToFieldMap = keyToFieldMap;
        for (int i = 0; i < separators.size(); ++i) {
            separators.set(i, StringEscapeUtils.unescapeJava((String)separators.get(i)));
        }
        this.separatorRegex = "\\Q" + StringUtils.join(separators, (String)"\\E|\\Q") + "\\E";
    }

    @Override
    public void process(Map<String, Object> input) {
        log.debug("The input to the KeyValue stage is [{}] ", input);
        Object o = input.get(this.message);
        if (o != null) {
            this.parseKeyValue(input, o);
            if (this.source != null && !this.source.isEmpty()) {
                for (String keyValPair : this.source) {
                    if (keyValPair.equalsIgnoreCase("message")) continue;
                    input.remove(keyValPair);
                }
            }
        }
        this.invokeNext(input);
    }

    private void parseKeyValue(Map<String, Object> input, Object o) {
        if (this.source == null || this.source.isEmpty()) {
            String parsedString = o.toString();
            this.extractAndStore(input, parsedString, "message");
        } else {
            for (String s : this.source) {
                String parsedString = null;
                if (input.get(s) != null) {
                    parsedString = input.get(s).toString();
                }
                if (parsedString == null) continue;
                this.extractAndStore(input, parsedString, s);
            }
        }
    }

    private boolean extractAndStore(Map<String, Object> input, String parsedString, String inputKey) {
        String[] keyValues;
        Object fieldValue = input.get(inputKey);
        int startIndex = 0;
        if (fieldValue instanceof PositionalFieldInfo) {
            startIndex = ((PositionalFieldInfo)input.get(inputKey)).getStart();
        }
        int parsedStringStartIndex = 0;
        for (String keyValue : keyValues = parsedString.split(this.separatorRegex)) {
            for (String split : this.splits) {
                int splitIndex = keyValue.indexOf(split);
                if (splitIndex == -1) continue;
                String[] kv = StringUtils.split((String)keyValue, (String)split);
                if (kv.length != 2) {
                    log.debug("KeyValue [{}] did not match with the splitter : [{}].", (Object)keyValue, (Object)split);
                    continue;
                }
                String key = kv[0];
                String value = kv[1];
                int valueStartIndex = startIndex + parsedString.indexOf(value, parsedStringStartIndex + key.length());
                int valueEndIndex = valueStartIndex + value.length();
                if (this.trim != null && !this.trim.isEmpty()) {
                    for (String trimChar : this.trim) {
                        key = this.trimString(key, trimChar);
                        value = this.trimString(value, trimChar);
                    }
                }
                if (key.equalsIgnoreCase(null)) continue;
                if (key.equalsIgnoreCase("message")) {
                    log.warn("Dropping key [{}] and value [{}] as it matches reserved field name.", (Object)key, (Object)value);
                    continue;
                }
                if (this.include == null) {
                    input.put(key, new PositionalFieldInfo(value, valueStartIndex, valueEndIndex));
                    break;
                }
                if (!this.include.contains(key)) continue;
                Object castedValue = value;
                String fieldName = key;
                if (this.keyToFieldMap != null && this.keyToFieldMap.containsKey(key)) {
                    LogFieldMetadata logField = this.keyToFieldMap.get(key);
                    fieldName = logField.getFieldName();
                    castedValue = FieldValueHelper.cast(fieldName, value, logField.getType());
                }
                if (castedValue == null) break;
                input.put(fieldName, new PositionalFieldInfo(castedValue, valueStartIndex, valueEndIndex));
                break;
            }
            parsedStringStartIndex += keyValue.length() + 1;
        }
        return false;
    }

    private String trimString(String trimString, String trimExp) {
        String trimmedString = trimString;
        if (trimExp != null) {
            trimmedString = StringUtils.strip((String)trimString, (String)trimExp);
        }
        return trimmedString;
    }
}

