/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.guid;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.xform.guid.LogAnalyticsDecryptionUtil;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestGuidStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestGuidStage.class);
    private static final String DESTINATION_FIELD = "requestGUID";
    static final String REQUEST_GUID_PREFIX = "AD_REQUEST_GUID[";
    static final char REQUEST_GUID_END_CHAR = ']';
    static final int REQUEST_GUID_PREFIX_LENGTH = "AD_REQUEST_GUID[".length();
    private static final Set<Character> SPECIAL_CHARACTER_IN_ENCRYPTED_GUID = ImmutableSet.of((Object)Character.valueOf('-'), (Object)Character.valueOf('+'), (Object)Character.valueOf('/'));
    private final String source;
    private final LogAnalyticsDecryptionUtil logAnalyticsDecryptionUtil;
    private final StringBuilder reusableStringBuilder;

    public RequestGuidStage(PipelineStageParameters<Map<String, Object>> parameters, String source, String key) {
        super(parameters);
        this.source = source;
        this.reusableStringBuilder = new StringBuilder();
        this.logAnalyticsDecryptionUtil = new LogAnalyticsDecryptionUtil(key);
    }

    @Override
    public void process(Map<String, Object> input) {
        Object sourceObject = input.get(this.source);
        if (sourceObject != null) {
            this.parseRequestGuid(input, sourceObject);
            if (!"message".equalsIgnoreCase(this.source)) {
                input.remove(this.source);
            }
        }
        this.invokeNext(input);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseRequestGuid(Map<String, Object> input, Object sourceObject) {
        String sourceString = sourceObject.toString();
        int sourceLength = sourceString.length();
        int prefixStartIndex = sourceString.indexOf(REQUEST_GUID_PREFIX);
        if (prefixStartIndex < 0) {
            return;
        }
        int requestGuidStartIndex = prefixStartIndex + REQUEST_GUID_PREFIX_LENGTH;
        int lastCharIndexOfSource = sourceLength - 1;
        try {
            char character;
            for (int i = requestGuidStartIndex; i < sourceLength && (character = sourceString.charAt(i)) != ']'; ++i) {
                if (i == lastCharIndexOfSource) {
                    return;
                }
                if (!Character.isLetterOrDigit(character) && !SPECIAL_CHARACTER_IN_ENCRYPTED_GUID.contains(Character.valueOf(character))) {
                    return;
                }
                this.reusableStringBuilder.append(character);
            }
            if (this.reusableStringBuilder.length() > 0) {
                String guid = this.reusableStringBuilder.toString();
                if (guid.startsWith("z")) {
                    guid = this.logAnalyticsDecryptionUtil.decrypt(guid.substring(1, guid.length()));
                }
                input.put(DESTINATION_FIELD, guid);
            }
        }
        finally {
            this.reusableStringBuilder.setLength(0);
        }
    }
}

