/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.grok;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.xform.regex.RegexUtils;
import com.appdynamics.common.util.charsequence.InterruptibleCharSequence;
import com.appdynamics.common.util.regex.RegexPattern;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegexStage.class);
    final String source;
    final RegexPattern[] regexPatterns;
    final Matcher[] matchers;
    private InterruptibleCharSequence reusableCharSequence;

    public RegexStage(PipelineStageParameters<Map<String, Object>> parameters, String source, ArrayList<RegexPattern> patterns) {
        super(parameters);
        this.source = source;
        int numberOfPatterns = patterns.size();
        this.regexPatterns = new RegexPattern[numberOfPatterns];
        this.matchers = new Matcher[numberOfPatterns];
        this.reusableCharSequence = new InterruptibleCharSequence();
        for (int i = 0; i < numberOfPatterns; ++i) {
            RegexPattern pattern = patterns.get(i);
            Matcher reusableMatcher = pattern.getPattern().matcher("");
            Preconditions.checkArgument((pattern.getAliases().length > 0 ? 1 : 0) != 0, (String)"The Grok pattern [%s] is not valid as it does not have any alias definitions. Without aliases, no sub-strings can be extracted into fields", (Object)pattern);
            this.regexPatterns[i] = pattern;
            this.matchers[i] = reusableMatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(Map<String, Object> input) {
        Object o = input.get(this.source);
        if (o != null) {
            String s = o.toString();
            try {
                this.reusableCharSequence.reinitialize((CharSequence)s);
                int matchCount = 0;
                matchCount = RegexUtils.matchAndExtract(this.regexPatterns, this.matchers, input, this.reusableCharSequence);
                if (log.isTraceEnabled()) {
                    log.trace("Found [{}] Capture Groups. End result is [{}]", (Object)matchCount, input);
                }
            }
            finally {
                this.reusableCharSequence.reinitialize((CharSequence)"");
            }
        }
        this.invokeNext(input);
    }
}

