/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.grok;

import com.appdynamics.analytics.pipeline.xform.regex.RegexUtils;
import com.appdynamics.common.util.charsequence.InterruptibleCharSequence;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.regex.RegexPattern;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;

public final class GrokUtils {
    public static final String GROK_PACKAGE = "grok";
    public static final String GROK_RESOURCE_PATH = ".*\\.grok";

    public static List<InputStream> getGrokFromResourcesSection() {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().setScanners(new Scanner[]{new SubTypesScanner(false), new ResourcesScanner()}).setUrls(ClasspathHelper.forPackage((String)GROK_PACKAGE, (ClassLoader[])new ClassLoader[0])));
        Set allClasses = reflections.getResources(Pattern.compile(GROK_RESOURCE_PATH));
        ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
        for (String clazz : allClasses) {
            InputStream inputStream = GrokUtils.class.getResourceAsStream("/" + clazz);
            inputStreams.add(inputStream);
        }
        return inputStreams;
    }

    public static Map<String, Object> getFieldsExtractedFromString(String originalString, String pattern, Grok grok) {
        HashMap<String, Object> extractedFieldsFromString = new HashMap<String, Object>();
        InterruptibleCharSequence charSequence = new InterruptibleCharSequence();
        RegexPattern regexPattern = grok.compile(pattern);
        RegexPattern[] regexPatterns = new RegexPattern[]{regexPattern};
        Matcher matcher = regexPattern.getPattern().matcher("");
        Matcher[] matchers = new Matcher[]{matcher};
        charSequence.reinitialize((CharSequence)originalString);
        RegexUtils.matchAndExtract(regexPatterns, matchers, extractedFieldsFromString, charSequence);
        return extractedFieldsFromString;
    }
}

