/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.grok;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStageFactory;
import com.appdynamics.analytics.pipeline.xform.Constants;
import com.appdynamics.analytics.pipeline.xform.grok.GrokStageConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.GrokStageFactoryConfiguration;
import com.appdynamics.analytics.pipeline.xform.grok.GrokStageResource;
import com.appdynamics.analytics.pipeline.xform.grok.NonGrokPattern;
import com.appdynamics.analytics.pipeline.xform.grok.RegexStage;
import com.appdynamics.common.util.configuration.ConfigurationHelper;
import com.appdynamics.common.util.grok.Grok;
import com.appdynamics.common.util.regex.RegexPattern;
import com.appdynamics.common.util.type.ValueType;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import io.dropwizard.core.setup.Environment;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrokStageFactory
extends AbstractPipelineStageFactory<Map<String, Object>, Map<String, Object>, GrokStageFactoryConfiguration, GrokStageConfiguration> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GrokStageFactory.class);
    private static final String DEBUG_GROK_ENDPOINT_ENABLED_PROPERTY = "ad.debug.grok.endpoint.enabled";
    private static final String DEBUG_GROK_ENDPOINT_ENABLED_PROPERTY_DEFAULT = "false";
    @Inject
    private volatile Grok grok;

    @Inject
    public void start(Environment environment) {
        GrokStageResource grokToolResource = new GrokStageResource(this);
        boolean debugGrokEndpointEnabled = Boolean.parseBoolean(ConfigurationHelper.resolveProperty((String)DEBUG_GROK_ENDPOINT_ENABLED_PROPERTY, (String)DEBUG_GROK_ENDPOINT_ENABLED_PROPERTY_DEFAULT));
        if (debugGrokEndpointEnabled) {
            environment.jersey().register((Object)grokToolResource);
        }
    }

    public RegexStage create(PipelineStageParameters<Map<String, Object>> parameters) {
        GrokStageConfiguration stageConfiguration = (GrokStageConfiguration)this.extract(parameters);
        String source = stageConfiguration.mergeSourceAndValidate(((GrokStageFactoryConfiguration)this.getConfiguration()).getSource());
        String configPattern = stageConfiguration.getPattern();
        ArrayList configPatterns = stageConfiguration.getPatterns();
        if (configPatterns == null) {
            configPatterns = Lists.newArrayList();
        }
        if (configPattern != null) {
            configPatterns.add(configPattern);
        }
        ArrayList<RegexPattern> regexPatterns = new ArrayList<RegexPattern>(configPatterns.size());
        for (String pattern : configPatterns) {
            RegexPattern regexPattern = this.grok.compile(pattern);
            ArrayList<String> alteredFields = new ArrayList<String>();
            for (String reservedField : Constants.RESERVED_FIELDS) {
                if (!regexPattern.removeByAlias(reservedField)) continue;
                alteredFields.add(reservedField);
            }
            if (!alteredFields.isEmpty()) {
                log.warn("The following reserved fields [{}] were removed from the given grok pattern [{}]", alteredFields, (Object)pattern);
            }
            regexPatterns.add(regexPattern);
        }
        if (stageConfiguration.getNonGrokPatterns() != null) {
            for (NonGrokPattern nonGrok : stageConfiguration.getNonGrokPatterns()) {
                regexPatterns.add(new RegexPattern(Pattern.compile(nonGrok.getRegex()), new String[]{nonGrok.getAlias()}, new String[]{nonGrok.getAlias()}, new int[]{1}, new ValueType[]{nonGrok.getValueType()}));
            }
        }
        RegexStage stage = new RegexStage(parameters, source, regexPatterns);
        log.trace("Pipeline stage [{} {}] has been configured to use [{}] as source to extract fields using the patterns {}", new Object[]{parameters.getPipelineId(), this.getUri(), source, configPatterns});
        return stage;
    }

    @Generated
    public void setGrok(Grok grok) {
        this.grok = grok;
    }
}

