/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.grok;

import com.appdynamics.analytics.pipeline.xform.grok.NonGrokPattern;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import com.appdynamics.common.util.grok.GrokParser;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import jakarta.validation.ConstraintValidatorContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import lombok.Generated;

@ManualValidated
public class GrokStageConfiguration
implements ManualValidateable {
    String source = "message";
    @Deprecated
    String pattern;
    List<String> patterns;
    List<NonGrokPattern> nonGrokPatterns;

    public boolean validate(ConstraintValidatorContext context) {
        if (Strings.isNullOrEmpty((String)this.pattern) && (this.patterns == null || this.patterns.isEmpty()) && (this.nonGrokPatterns == null || this.nonGrokPatterns.isEmpty())) {
            context.buildConstraintViolationWithTemplate("At least one pattern must be defined").addPropertyNode("pattern / patterns").addConstraintViolation();
            return false;
        }
        ArrayList<String> allPatterns = new ArrayList<String>();
        if (this.patterns != null && !this.patterns.isEmpty()) {
            allPatterns.addAll(this.patterns);
        }
        if (!Strings.isNullOrEmpty((String)this.pattern)) {
            allPatterns.add(this.pattern);
        }
        for (String pattern : allPatterns) {
            if (!GrokParser.duplicateAliasesExist((String)pattern)) continue;
            context.buildConstraintViolationWithTemplate("Duplicate fields defined in patterns").addPropertyNode("pattern / patterns").addConstraintViolation();
            return false;
        }
        HashSet<String> allNonGrokAliasNames = new HashSet<String>();
        if (this.nonGrokPatterns != null) {
            for (NonGrokPattern nonGrokPattern : this.nonGrokPatterns) {
                allNonGrokAliasNames.add(nonGrokPattern.getAlias());
            }
            if (allNonGrokAliasNames.size() != this.nonGrokPatterns.size()) {
                context.buildConstraintViolationWithTemplate("Duplicate non-grok alias names defined in nonGrokPatterns").addPropertyNode("nonGrokPatterns").addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    public String mergeSourceAndValidate(String thatOptSource) {
        try {
            this.source = (String)MoreObjects.firstNonNull((Object)this.source, (Object)thatOptSource);
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("The [source] field has not been specified", (Throwable)e);
        }
        return this.source;
    }

    @Generated
    public GrokStageConfiguration() {
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Deprecated
    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public List<String> getPatterns() {
        return this.patterns;
    }

    @Generated
    public List<NonGrokPattern> getNonGrokPatterns() {
        return this.nonGrokPatterns;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Deprecated
    @Generated
    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    @Generated
    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    @Generated
    public void setNonGrokPatterns(List<NonGrokPattern> nonGrokPatterns) {
        this.nonGrokPatterns = nonGrokPatterns;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrokStageConfiguration)) {
            return false;
        }
        GrokStageConfiguration other = (GrokStageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        List<String> this$patterns = this.getPatterns();
        List<String> other$patterns = other.getPatterns();
        if (this$patterns == null ? other$patterns != null : !((Object)this$patterns).equals(other$patterns)) {
            return false;
        }
        List<NonGrokPattern> this$nonGrokPatterns = this.getNonGrokPatterns();
        List<NonGrokPattern> other$nonGrokPatterns = other.getNonGrokPatterns();
        return !(this$nonGrokPatterns == null ? other$nonGrokPatterns != null : !((Object)this$nonGrokPatterns).equals(other$nonGrokPatterns));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrokStageConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        List<String> $patterns = this.getPatterns();
        result = result * 59 + ($patterns == null ? 43 : ((Object)$patterns).hashCode());
        List<NonGrokPattern> $nonGrokPatterns = this.getNonGrokPatterns();
        result = result * 59 + ($nonGrokPatterns == null ? 43 : ((Object)$nonGrokPatterns).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GrokStageConfiguration(source=" + this.getSource() + ", pattern=" + this.getPattern() + ", patterns=" + String.valueOf(this.getPatterns()) + ", nonGrokPatterns=" + String.valueOf(this.getNonGrokPatterns()) + ")";
    }
}

