/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.fieldrestriction;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldRestrictionStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldRestrictionStage.class);
    final int maxMapSize;
    final int maxLogLineSize;
    final int maxExtractedFieldSize;
    final String lineEndingCharacter;
    final Predicate<Map.Entry<String, Object>> removableFieldPredicate;
    private static final Set<String> MANDATORY_FIELDS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER){
        {
            this.add("message");
            this.add("pickupTimestamp");
            this.add("eventTimestamp");
            this.add("host");
            this.add("source");
            this.add("sourceType");
            this.add("requestGUID");
            this.add("appName");
            this.add("nodeName");
            this.add("tierName");
        }
    };

    public FieldRestrictionStage(PipelineStageParameters<Map<String, Object>> parameters, int maxMapSize, int maxLogLineSize, int maxExtractedFieldSize, String lineEndingCharacter) {
        super(parameters);
        this.maxMapSize = maxMapSize;
        this.maxLogLineSize = maxLogLineSize;
        this.maxExtractedFieldSize = maxExtractedFieldSize;
        this.lineEndingCharacter = lineEndingCharacter;
        this.removableFieldPredicate = new Predicate<Map.Entry<String, Object>>(){

            public boolean apply(Map.Entry<String, Object> input) {
                return !MANDATORY_FIELDS.contains(input.getKey());
            }
        };
    }

    @Override
    public void process(Map<String, Object> input) {
        if (input.size() > this.maxMapSize) {
            this.restrictMapSize(input);
        }
        if (input.containsKey("message")) {
            String message = input.get("message").toString();
            if (message.length() > this.maxExtractedFieldSize) {
                this.enforceFieldLengthRestriction(input);
            }
            this.invokeNext(input);
        } else {
            log.error("Message field is null");
        }
    }

    private void restrictMapSize(Map<String, Object> input) {
        int size = input.size();
        ArrayList<String> removeFields = new ArrayList<String>();
        for (Map.Entry entry : Iterables.filter(input.entrySet(), this.removableFieldPredicate)) {
            if (size <= this.maxMapSize) break;
            removeFields.add((String)entry.getKey());
            --size;
        }
        for (String key : removeFields) {
            log.warn(String.format("Dropping field %s. Maximum number of fields that can be collected is %d", key, this.maxMapSize));
            input.remove(key);
        }
    }

    private void enforceFieldLengthRestriction(Map<String, Object> input) {
        for (Map.Entry<String, Object> entry : input.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue().toString();
            int maxSize = key.equalsIgnoreCase("message") ? this.maxLogLineSize : this.maxExtractedFieldSize;
            if (value.length() < maxSize) continue;
            String strippedValue = this.stripField(key, value, maxSize);
            input.put(key, strippedValue);
        }
    }

    private String stripField(String field, String value, int strippedSize) {
        log.warn("For field [{}], captured value is too long, reducing size to [{}]", (Object)field, (Object)strippedSize);
        return value.substring(0, strippedSize) + this.lineEndingCharacter;
    }
}

