/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.xform.field.FieldTransformationConfiguration;
import com.appdynamics.common.util.configuration.ConfigurationException;
import com.appdynamics.common.util.configuration.ManualValidateable;
import com.appdynamics.common.util.configuration.ManualValidated;
import com.appdynamics.common.util.type.ValueType;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import jakarta.validation.ConstraintValidatorContext;
import java.util.List;
import lombok.Generated;

@ManualValidated
public class FieldTransformationStageConfiguration
implements ManualValidateable {
    String source;
    List<FieldTransformationConfiguration> fields;

    public String mergeSourceAndValidate(String thatOptSource) {
        try {
            this.source = (String)MoreObjects.firstNonNull((Object)this.source, (Object)thatOptSource);
        }
        catch (NullPointerException e) {
            throw new ConfigurationException("The [source] field has not been specified", (Throwable)e);
        }
        return this.source;
    }

    public boolean validate(ConstraintValidatorContext context) {
        if (this.fields != null && !this.fields.isEmpty()) {
            for (FieldTransformationConfiguration ft : this.fields) {
                if (Strings.isNullOrEmpty((String)ft.getField())) {
                    context.buildConstraintViolationWithTemplate("The field name must be specified").addPropertyNode("FieldTransformation.field").addConstraintViolation();
                    return false;
                }
                if (Strings.isNullOrEmpty((String)ft.getAlias()) && ft.getType() == null) {
                    context.buildConstraintViolationWithTemplate("At least one operation to be performed on the field must be defined").addPropertyNode("FieldTransformation.type / FieldTransformation.alias").addConstraintViolation();
                    return false;
                }
                if (ft.getType() != ValueType.TIMESTAMP || !Strings.isNullOrEmpty((String)ft.getFormat())) continue;
                context.buildConstraintViolationWithTemplate("If Type is equal to " + String.valueOf(ValueType.TIMESTAMP) + " format must be specified").addPropertyNode("FieldTransformation.type / FieldTransformation.format").addConstraintViolation();
                return false;
            }
        }
        return true;
    }

    @Generated
    public FieldTransformationStageConfiguration() {
    }

    @Generated
    public String getSource() {
        return this.source;
    }

    @Generated
    public List<FieldTransformationConfiguration> getFields() {
        return this.fields;
    }

    @Generated
    public void setSource(String source) {
        this.source = source;
    }

    @Generated
    public void setFields(List<FieldTransformationConfiguration> fields) {
        this.fields = fields;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FieldTransformationStageConfiguration)) {
            return false;
        }
        FieldTransformationStageConfiguration other = (FieldTransformationStageConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        List<FieldTransformationConfiguration> this$fields = this.getFields();
        List<FieldTransformationConfiguration> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FieldTransformationStageConfiguration;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        List<FieldTransformationConfiguration> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FieldTransformationStageConfiguration(source=" + this.getSource() + ", fields=" + String.valueOf(this.getFields()) + ")";
    }
}

