/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.xform.field;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.analytics.pipeline.xform.field.FieldTransformationConfiguration;
import com.appdynamics.analytics.pipeline.xform.map.PositionalFieldInfo;
import com.appdynamics.common.util.type.ValueType;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldTransformationStage
extends AbstractPipelineStage<Map<String, Object>, Map<String, Object>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FieldTransformationStage.class);
    final String source;
    final List<FieldTransformationConfiguration> fields;

    public FieldTransformationStage(PipelineStageParameters<Map<String, Object>> parameters, String source, List<FieldTransformationConfiguration> fields) {
        super(parameters);
        this.source = source;
        this.fields = fields;
    }

    @Override
    public void process(Map<String, Object> input) {
        log.debug("The input to the Transformation stage is [{}] ", input);
        Object o = input.get(this.source);
        if (o != null) {
            this.transformFieldTypeOrAlias(input);
        }
        this.invokeNext(input);
    }

    private void transformFieldTypeOrAlias(Map<String, Object> input) {
        if (this.fields == null || this.fields.isEmpty()) {
            return;
        }
        int transformationListSize = this.fields.size();
        for (int i = 0; i < transformationListSize; ++i) {
            FieldTransformationConfiguration fieldTransformationConfig = this.fields.get(i);
            String field = fieldTransformationConfig.getField();
            ValueType valueType = fieldTransformationConfig.getType();
            String alias = fieldTransformationConfig.getAlias();
            String format = fieldTransformationConfig.getFormat();
            int startIndex = -1;
            int endIndex = -1;
            if (!input.containsKey(field)) continue;
            Object fieldValue = input.get(field);
            if (fieldValue != null && valueType != null) {
                fieldValue = valueType.cast(fieldValue.toString(), format);
                input.remove(field);
            }
            if (!Strings.isNullOrEmpty((String)alias) && !alias.equalsIgnoreCase("message")) {
                input.remove(field);
                field = alias;
            }
            if (fieldValue == null) continue;
            if (fieldValue instanceof PositionalFieldInfo) {
                startIndex = ((PositionalFieldInfo)fieldValue).getStart();
                endIndex = ((PositionalFieldInfo)fieldValue).getEnd();
                input.put(field, new PositionalFieldInfo(fieldValue, startIndex, endIndex));
                continue;
            }
            input.put(field, fieldValue);
        }
    }
}

