/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.util;

import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.common.util.concurrent.SingleWriterCounter;
import com.appdynamics.common.util.execution.Countable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineStage<IN, OUT>
implements PipelineStage<IN, OUT>,
Countable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineStage.class);
    protected final Object pipelineId;
    protected final PipelineStage<? super OUT, ?> optionalNextStage;
    private final SingleWriterCounter callCounter;

    protected AbstractPipelineStage(PipelineStageParameters<OUT> parameters) {
        this.pipelineId = parameters.getPipelineId();
        this.optionalNextStage = parameters.getOptionalNextStage();
        this.callCounter = new SingleWriterCounter();
    }

    public final long getCount() {
        return this.callCounter.get();
    }

    public final long incrementCount() {
        return this.callCounter.incrementAndGet();
    }

    public void start() {
        log.debug("Starting pipeline stage [{}]", (Object)this.printableName());
    }

    protected final void invokeNext(OUT input) {
        if (this.optionalNextStage == null) {
            return;
        }
        if (log.isTraceEnabled()) {
            log.trace("Invoking stage [{}] with [{}]", (Object)this.optionalNextStage.getClass().getName(), input);
        }
        if (this.optionalNextStage instanceof Countable) {
            ((Countable)this.optionalNextStage).incrementCount();
        }
        this.optionalNextStage.process(input);
    }

    public void stop() {
        log.debug("Stopped pipeline stage [{}]", (Object)this.printableName());
    }

    protected final String printableName() {
        String name = this.getClass().getSimpleName();
        if (name.length() == 0) {
            name = this.getClass().getName();
        }
        if (this.pipelineId != null) {
            return String.valueOf(this.pipelineId) + " (" + name + ")";
        }
        return name;
    }

    public String toString() {
        return this.printableName();
    }
}

