/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.source;

import com.appdynamics.analytics.message.MessageSources;
import com.appdynamics.analytics.message.api.MessagePack;
import com.appdynamics.analytics.message.api.MessageSource;
import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.source.MessageSourceConfiguration;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.common.util.exception.ExceptionHandler;
import com.appdynamics.common.util.exception.Exceptions;
import com.appdynamics.common.util.execution.Operation;
import com.appdynamics.common.util.execution.Pausable;
import com.appdynamics.common.util.execution.Retriable;
import com.appdynamics.common.util.execution.RetryConfiguration;
import com.appdynamics.common.util.execution.RetryWrapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageSourceStage<SRC_ID, MSG>
extends AbstractPipelineStage<Void, MessagePack<SRC_ID, MSG>>
implements Pausable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageSourceStage.class);
    final PipelineStageParameters<MessagePack<SRC_ID, MSG>> parameters;
    final MessageSourceConfiguration configuration;
    final MessageSources messageSources;
    final ExceptionHandler exceptionHandler;
    final Lock pauseLock = new ReentrantLock();
    final Condition pausedCondition = this.pauseLock.newCondition();
    volatile boolean isPauseRequested;
    private volatile MessageSource<SRC_ID, MSG> source;
    private volatile RetryWrapper<SRC_ID> optRetryWrapper;

    MessageSourceStage(PipelineStageParameters<MessagePack<SRC_ID, MSG>> parameters, MessageSourceConfiguration configuration, MessageSources messageSources) {
        super(parameters);
        this.parameters = parameters;
        this.configuration = configuration;
        this.messageSources = messageSources;
        this.exceptionHandler = new ExceptionHandler(log, String.format("Pipeline [%s] was interrupted when it was polling the message source", this.printableName()), String.format("Transient error occurred while processing input on pipeline [%s]", this.printableName()), String.format("Permanent error occurred while processing input on pipeline [%s]", this.printableName()), String.format("Unexpected error occurred while processing input on pipeline [%s]", this.printableName()), configuration.isRethrowUnknownExceptions());
    }

    RetryWrapper<SRC_ID> getOptRetryWrapper() {
        return this.optRetryWrapper;
    }

    @Override
    public void start() {
        Object messageSourceId = this.configuration.getMessageSourceId();
        Object messageSourceParams = this.configuration.getMessageSourceParams();
        this.source = messageSourceParams == null ? this.messageSources.get(messageSourceId) : this.messageSources.get(messageSourceId, messageSourceParams);
        Preconditions.checkArgument((this.source != null ? 1 : 0) != 0, (Object)("There is no message source registered under [" + String.valueOf(messageSourceId) + "]"));
        RetryConfiguration optRetryConfiguration = this.configuration.getRetry();
        if (this.source.supportsRetriable() && optRetryConfiguration == null) {
            log.debug("The source ([{}]) from which this pipeline ([{}]) is configured to consume produces [{}] messages. But retry options have not been provided, so retry options with default values will be used", new Object[]{this.source.getId(), this.parameters.getPipelineId(), Retriable.class.getSimpleName()});
            optRetryConfiguration = new RetryConfiguration();
        } else if (!this.source.supportsRetriable() && optRetryConfiguration != null) {
            log.warn("The source ([{}]) from which this pipeline ([{}]) is configured to consume, does not produce [{}] messages. But retry options have been provided and so they will be ignored", new Object[]{this.source.getId(), this.parameters.getPipelineId(), Retriable.class.getSimpleName()});
            optRetryConfiguration = null;
        }
        this.optRetryWrapper = optRetryConfiguration != null ? new RetryWrapper(messageSourceId, optRetryConfiguration) : null;
    }

    @Override
    public final void process(Void input) {
        try {
            this.doWork();
        }
        catch (InterruptedException e) {
            Exceptions.rethrowAsRuntimeException((InterruptedException)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() throws InterruptedException {
        boolean hasNext = this.optionalNextStage != null;
        boolean useRetryWrapper = this.optRetryWrapper != null;
        int maxMessagesPerPoll = this.configuration.getMaxMessagesPerPoll();
        long pollTimeoutMillis = this.configuration.getPollTimeoutMillis();
        RetryWrapper<SRC_ID> localRetryWrapper = this.optRetryWrapper;
        MessageSource<SRC_ID, MSG> localSource = this.source;
        PipelineStage localNextStage = this.optionalNextStage;
        int attempt = 0;
        while (true) {
            MessagePack<SRC_ID, MSG> msgPack = null;
            while (this.isPauseRequested) {
                this.pauseLock.lock();
                try {
                    if (localSource instanceof Pausable) {
                        ((Pausable)localSource).pause();
                        localSource.poll(0, 0L, TimeUnit.MILLISECONDS);
                    }
                    this.pausedCondition.await(1L, TimeUnit.SECONDS);
                    if (!log.isDebugEnabled() || ++attempt % 60 != 0) continue;
                    log.debug("Pipeline with id [{}] consuming from source [{}] has been paused", this.parameters.getPipelineId(), this.source.getId());
                    attempt = 0;
                }
                finally {
                    this.pauseLock.unlock();
                }
            }
            try {
                msgPack = localSource.poll(maxMessagesPerPoll, pollTimeoutMillis, TimeUnit.MILLISECONDS);
                if (msgPack == null || !hasNext) continue;
                if (useRetryWrapper) {
                    Retriable retriable = (Retriable)msgPack;
                    PipelineStage operation = localNextStage;
                    localRetryWrapper.invoke(retriable, (Operation)operation);
                    continue;
                }
                localNextStage.process(msgPack);
                continue;
            }
            catch (Throwable t) {
                this.exceptionHandler.handle(t);
                continue;
            }
            break;
        }
    }

    @Override
    public final void stop() {
        try {
            this.source.close();
            this.source = null;
        }
        catch (IOException e) {
            log.warn("Failed to close the message source", (Throwable)e);
        }
        super.stop();
    }

    public void pause() {
        log.debug("Pausing pipeline with id [{}] consuming from source [{}]", this.parameters.getPipelineId(), this.source.getId());
        this.isPauseRequested = true;
    }

    public void resume() {
        if (!this.isPauseRequested) {
            return;
        }
        log.debug("Resuming pipeline with id [{}] consuming from source [{}]", this.parameters.getPipelineId(), this.source.getId());
        this.pauseLock.lock();
        try {
            this.isPauseRequested = false;
            if (this.source instanceof Pausable) {
                ((Pausable)this.source).resume();
            }
            this.pausedCondition.signalAll();
        }
        finally {
            this.pauseLock.unlock();
        }
    }

    public boolean isPaused() {
        return this.isPauseRequested;
    }
}

