/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.mem;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.common.util.exception.Exceptions;
import com.google.common.base.Throwables;
import java.util.ConcurrentModificationException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UntapStage<I>
extends AbstractPipelineStage<Void, I> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UntapStage.class);
    private final BlockingQueue<I> queue;
    private final CountDownLatch stopWaitLatch;
    private final AtomicReference<Thread> processingThread;
    private volatile boolean stop;

    public UntapStage(PipelineStageParameters<I> parameters, BlockingQueue<I> queue) {
        super(parameters);
        this.queue = queue;
        this.stopWaitLatch = new CountDownLatch(1);
        this.processingThread = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void process(Void input) {
        if (!this.processingThread.compareAndSet(null, Thread.currentThread())) {
            Object msg = "Pipeline stage is already being processed by another thread";
            Thread otherThread = this.processingThread.get();
            if (otherThread == null) throw new ConcurrentModificationException((String)msg);
            msg = (String)msg + " [" + otherThread.getName() + "]";
            throw new ConcurrentModificationException((String)msg);
        }
        block19: while (true) {
            try {
                while (!this.stop) {
                    I i = this.queue.take();
                    try {
                        this.invokeNext(i);
                        continue block19;
                    }
                    catch (Exception e) {
                        this.onError(i, e);
                    }
                    catch (Throwable t) {
                        this.onUnrecoverableError(i, t);
                        throw t;
                        return;
                    }
                }
            }
            catch (InterruptedException e) {
                Exceptions.rethrowAsRuntimeException((InterruptedException)e);
                return;
            }
            catch (Exception e) {
                Throwables.propagate((Throwable)e);
                return;
            }
        }
        finally {
            try {
                this.stopWaitLatch.countDown();
            }
            finally {
                this.processingThread.set(null);
            }
        }
    }

    protected void onError(I i, Exception e) throws Exception {
        log.error("Error occurred while processing input on pipeline [{}]", (Object)this.printableName(), (Object)e);
    }

    protected void onUnrecoverableError(I i, Throwable t) {
        log.error("Unrecoverable error occurred while processing input on pipeline [{}]", (Object)this.printableName(), (Object)t);
    }

    @Override
    public final void stop() {
        this.stop = true;
        Thread otherThread = this.processingThread.get();
        if (otherThread != null) {
            otherThread.interrupt();
        }
        try {
            this.stopWaitLatch.await();
        }
        catch (InterruptedException e) {
            Exceptions.rethrowAsRuntimeException((InterruptedException)e);
        }
        super.stop();
    }
}

