/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.mem;

import com.appdynamics.analytics.pipeline.api.PipelineStageParameters;
import com.appdynamics.analytics.pipeline.util.AbstractPipelineStage;
import com.appdynamics.common.util.exception.Exceptions;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TapStage<I>
extends AbstractPipelineStage<I, I> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TapStage.class);
    private final BlockingQueue<I> queue;

    public TapStage(PipelineStageParameters<I> parameters, BlockingQueue<I> queue) {
        super(parameters);
        this.queue = queue;
    }

    public BlockingQueue<I> getQueue() {
        return this.queue;
    }

    @Override
    public void process(I input) {
        try {
            boolean submitted = false;
            int i = 0;
            while (!submitted) {
                submitted = this.queue.offer(input, 10L, TimeUnit.SECONDS);
                if (!submitted && i % 6 == 0) {
                    log.warn("The queue into which [{}] is configured to offer messages appears to be full. Attempts will be made to retry until space becomes available", (Object)this.printableName());
                }
                ++i;
            }
        }
        catch (InterruptedException e) {
            Exceptions.rethrowAsRuntimeException((InterruptedException)e);
        }
        this.invokeNext(input);
    }
}

