/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.http;

import com.appdynamics.analytics.pipeline.http.PostReceiverConfiguration;
import com.appdynamics.analytics.queue.Queues;
import com.appdynamics.common.framework.util.Module;
import com.appdynamics.common.util.health.ConsolidatedHealthCheck;
import com.appdynamics.common.util.health.HealthCheckable;
import com.appdynamics.common.util.health.MeteredHealthCheck;
import com.codahale.metrics.Meter;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.dropwizard.core.setup.Environment;
import jakarta.servlet.Servlet;
import jakarta.servlet.ServletRegistration;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPostReceiver<OUT, CFG extends PostReceiverConfiguration>
extends Module<CFG> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPostReceiver.class);
    @Inject
    private volatile Environment environment;
    @Inject
    protected volatile Queues queues;
    @Inject
    private volatile ConsolidatedHealthCheck healthCheck;
    private volatile boolean stopCalled;
    private BlockingQueue<OUT> dispatchQueue;
    private List<String> urlPatterns;
    private long timeoutSecs;
    private Meter meterSuccess;
    private Meter meterTimeout;
    private Meter meterError;

    protected AbstractPostReceiver() {
    }

    @PostConstruct
    public void onStart() {
        PostReceiverConfiguration cfg = (PostReceiverConfiguration)this.getConfiguration();
        this.dispatchQueue = this.queues.findOrSetupQueue(cfg);
        this.urlPatterns = cfg.getUrlPatterns();
        this.timeoutSecs = cfg.getAckTimeoutSeconds();
        String name = this.getUri() + "[" + String.valueOf(this.urlPatterns) + "]";
        MeteredHealthCheck meteredHealthCheck = new MeteredHealthCheck(name, this.environment);
        this.meterSuccess = meteredHealthCheck.getMeterSuccess();
        this.meterTimeout = meteredHealthCheck.getMeterTimeout();
        this.meterError = meteredHealthCheck.getMeterError();
        StreamRelayServlet servlet = new StreamRelayServlet();
        ServletRegistration.Dynamic servletBuilder = this.environment.servlets().addServlet(name, (Servlet)servlet);
        servletBuilder.addMapping(this.urlPatterns.toArray(new String[this.urlPatterns.size()]));
        this.healthCheck.register((HealthCheckable)meteredHealthCheck);
        log.debug("[{}] will receive messages on [{}] and forward them to queue [{}]", new Object[]{this.getUri(), this.urlPatterns, cfg.getQueueName()});
    }

    protected abstract OUT process(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ManagedException;

    @PreDestroy
    void onStop() {
        this.stopCalled = true;
    }

    @ThreadSafe
    class StreamRelayServlet
    extends HttpServlet {
        StreamRelayServlet() {
        }

        protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            try {
                Object output = AbstractPostReceiver.this.process(request, response);
                boolean success = AbstractPostReceiver.this.dispatchQueue.offer(output, AbstractPostReceiver.this.timeoutSecs, TimeUnit.SECONDS);
                if (success) {
                    response.setStatus(202);
                    AbstractPostReceiver.this.meterSuccess.mark();
                } else {
                    AbstractPostReceiver.this.meterTimeout.mark();
                    String msg = "Request could not be processed as the input queue is full";
                    log.error(msg);
                    response.sendError(408, msg);
                }
            }
            catch (ManagedException me) {
                AbstractPostReceiver.this.meterError.mark();
                log.error(me.message, (Throwable)me);
                response.sendError(me.httpStatusCodeToSend, Throwables.getRootCause((Throwable)me).getMessage());
            }
            catch (Exception e) {
                String msg = "Error occurred while processing message received over [" + String.valueOf(AbstractPostReceiver.this.urlPatterns) + "]";
                if (AbstractPostReceiver.this.stopCalled && e instanceof InterruptedException) {
                    log.debug(msg + ". Service is shutting down", (Throwable)e);
                    response.setStatus(503);
                }
                AbstractPostReceiver.this.meterError.mark();
                log.error(msg, (Throwable)e);
                response.sendError(500, Throwables.getRootCause((Throwable)e).getMessage());
            }
        }
    }

    public static class ManagedException
    extends Exception {
        private final int httpStatusCodeToSend;
        private final String message;

        public ManagedException(int httpStatusCodeToSend, String message) {
            this.httpStatusCodeToSend = httpStatusCodeToSend;
            this.message = message;
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }

        @Generated
        public int getHttpStatusCodeToSend() {
            return this.httpStatusCodeToSend;
        }

        @Override
        @Generated
        public String getMessage() {
            return this.message;
        }
    }
}

