/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.framework;

import com.appdynamics.analytics.pipeline.framework.Pipeline;
import com.appdynamics.analytics.pipeline.framework.PipelineConfiguration;
import com.appdynamics.analytics.pipeline.framework.PipelineIdReservedException;
import com.appdynamics.analytics.pipeline.framework.PipelineNotFoundException;
import com.appdynamics.analytics.pipeline.framework.Pipelines;
import com.appdynamics.analytics.shared.rest.exceptions.ErrorSubStatus;
import com.appdynamics.analytics.shared.rest.exceptions.StandardErrorSubStatusCodes;
import com.appdynamics.analytics.shared.rest.exceptions.jaxrs.base.NotAuthorizedJaxrsException;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="pipelines")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class PipelinesResource {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelinesResource.class);
    public static final String KEYWORD_START = "_start";
    public static final String KEYWORD_STOP = "_stop";
    public static final String X_ANALYTICS_AGENT_ACCESS_KEY = "X-Analytics-Agent-Access-Key";
    public static final String X_APPDYNAMICS_GLOBAL_ACCOUNT_NAME = "X-AppDynamics-Global-Account-Name";
    private final Pipelines pipelines;
    private final boolean authenticate;
    private final String globalAccountName;
    private final String accessKey;

    static void validateId(Object id) {
        if (id.equals(KEYWORD_START) || id.equals(KEYWORD_STOP)) {
            throw new PipelineIdReservedException(id);
        }
    }

    @GET
    public Collection<Object> getPipelines() {
        Collection pipelines = this.pipelines.getAll();
        ArrayList<Object> pipelineIds = new ArrayList<Object>(pipelines.size());
        for (Pipeline pipeline : pipelines) {
            pipelineIds.add(String.valueOf(pipeline.getId()) + " -- Current state: [" + pipeline.getDisplayState() + "]");
        }
        return pipelineIds;
    }

    @POST
    public Response addPipeline(@NotNull @Context HttpHeaders httpHeaders, @Valid PipelineConfiguration pipelineConfiguration) {
        if (this.authenticate) {
            this.authenticate(httpHeaders);
        }
        Object pipelineId = pipelineConfiguration.getId();
        PipelinesResource.validateId(pipelineId);
        this.pipelines.createAddAndStart(pipelineConfiguration);
        URI uri = UriBuilder.fromResource(PipelinesResource.class).build(new Object[]{pipelineId});
        return Response.created((URI)uri).build();
    }

    @Path(value="{pipelineId}/_start")
    @POST
    public Response startPipeline(@NotNull @Context HttpHeaders httpHeaders, @Valid @PathParam(value="pipelineId") String pipelineId) {
        if (this.authenticate) {
            this.authenticate(httpHeaders);
        }
        Pipeline pipeline = this.getPipeline(pipelineId);
        pipeline.start();
        this.pipelines.executePipeline(pipeline);
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="{pipelineId}")
    @GET
    public String getPipelineStatus(@Valid @PathParam(value="pipelineId") String pipelineId) {
        Pipeline pipeline = this.getPipeline(pipelineId);
        return pipeline.getState().name();
    }

    Pipeline getPipeline(String pipelineId) {
        Pipeline pipeline = (Pipeline)this.pipelines.get(pipelineId);
        if (pipeline == null) {
            throw new PipelineNotFoundException(pipelineId);
        }
        return pipeline;
    }

    @Path(value="{pipelineId}/_stop")
    @POST
    public Response stopPipeline(@NotNull @Context HttpHeaders httpHeaders, @Valid @PathParam(value="pipelineId") String pipelineId) {
        if (this.authenticate) {
            this.authenticate(httpHeaders);
        }
        Pipeline pipeline = this.getPipeline(pipelineId);
        pipeline.stop();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="{pipelineId}/_pause")
    @POST
    public Response pausePipeline(@NotNull @Context HttpHeaders httpHeaders, @Valid @PathParam(value="pipelineId") String pipelineId) {
        if (this.authenticate) {
            this.authenticate(httpHeaders);
        }
        Pipeline pipeline = this.getPipeline(pipelineId);
        pipeline.pause();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="{pipelineId}/_resume")
    @POST
    public Response resumePipeline(@NotNull @Context HttpHeaders httpHeaders, @Valid @PathParam(value="pipelineId") String pipelineId) {
        if (this.authenticate) {
            this.authenticate(httpHeaders);
        }
        Pipeline pipeline = this.getPipeline(pipelineId);
        pipeline.resume();
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    @Path(value="{pipelineId}")
    @DELETE
    public Response removePipeline(@NotNull @Context HttpHeaders httpHeaders, @Valid @PathParam(value="pipelineId") String pipelineId) {
        if (this.authenticate) {
            this.authenticate(httpHeaders);
        }
        Pipeline pipeline = this.getPipeline(pipelineId);
        this.pipelines.remove(pipelineId);
        if (pipeline.getState() == Pipeline.State.RUNNING || pipeline.getState() == Pipeline.State.IDLE) {
            pipeline.stop();
        }
        return Response.status((Response.Status)Response.Status.OK).build();
    }

    private void authenticate(@NonNull HttpHeaders httpHeaders) {
        if (httpHeaders == null) {
            throw new IllegalArgumentException("httpHeaders is marked non-null but is null");
        }
        String receivedAccessKey = httpHeaders.getHeaderString(X_ANALYTICS_AGENT_ACCESS_KEY);
        String receivedAccountName = httpHeaders.getHeaderString(X_APPDYNAMICS_GLOBAL_ACCOUNT_NAME);
        if (!this.accessKey.equals(receivedAccessKey) || !this.globalAccountName.equals(receivedAccountName)) {
            throw new AccountNotAuthorizedException();
        }
    }

    @ConstructorProperties(value={"pipelines", "authenticate", "globalAccountName", "accessKey"})
    @Generated
    public PipelinesResource(Pipelines pipelines, boolean authenticate, String globalAccountName, String accessKey) {
        this.pipelines = pipelines;
        this.authenticate = authenticate;
        this.globalAccountName = globalAccountName;
        this.accessKey = accessKey;
    }

    private static class AccountNotAuthorizedException
    extends NotAuthorizedJaxrsException {
        private AccountNotAuthorizedException() {
        }

        public ErrorSubStatus getSubStatus() {
            return StandardErrorSubStatusCodes.AUTH_ACCOUNT;
        }
    }
}

