/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.pipeline.framework;

import com.appdynamics.analytics.pipeline.api.PipelineStage;
import com.appdynamics.common.util.execution.Countable;
import com.appdynamics.common.util.execution.Pausable;
import com.appdynamics.common.util.item.Item;
import com.appdynamics.common.util.lifecycle.LifecycleAware;
import com.appdynamics.common.util.lifecycle.LifecycleHelper;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Pipeline<IN>
implements Item<Object>,
Callable<Void>,
LifecycleAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(Pipeline.class);
    final Object pipelineId;
    final PipelineStage[] pipelineStages;
    private final AtomicReference<State> state;
    private final AtomicReference<Thread> currentPipelineCallerThread;

    public Pipeline(Object pipelineId, PipelineStage[] pipelineStages) {
        this.pipelineId = pipelineId;
        this.pipelineStages = pipelineStages;
        this.state = new AtomicReference<State>(State.CREATED);
        this.currentPipelineCallerThread = new AtomicReference();
    }

    public Object getId() {
        return this.pipelineId;
    }

    public State getState() {
        return this.state.get();
    }

    public List<PipelineStage> getPipelineStages() {
        return ImmutableList.copyOf((Object[])this.pipelineStages);
    }

    public void start() {
        log.debug("Starting pipeline [{}]", this.getId());
        LifecycleHelper.startAll((Iterable)Lists.reverse(Arrays.asList(this.pipelineStages)));
        this.state.set(State.IDLE);
        log.info("Started pipeline [{}]", this.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(IN input) {
        PipelineStage p = this.pipelineStages[0];
        if (!this.currentPipelineCallerThread.compareAndSet(null, Thread.currentThread())) {
            throw new IllegalStateException("Pipeline [" + String.valueOf(this.getId()) + "] is being executed by another thread. Concurrent access is not allowed");
        }
        try {
            if (!this.state.compareAndSet(State.IDLE, State.RUNNING)) {
                throw new IllegalStateException("Pipeline [" + String.valueOf(this.getId()) + "] may already have been stopped. Current state is not [" + State.IDLE.name() + "]");
            }
            String id = String.valueOf(this.getId());
            String originalThreadName = Thread.currentThread().getName();
            String newThreadName = originalThreadName + " (" + id + ")";
            try {
                Thread.currentThread().setName(newThreadName);
                this.doCall(input, p, id);
            }
            finally {
                Thread.currentThread().setName(originalThreadName);
                this.state.set(State.IDLE);
            }
        }
        finally {
            this.currentPipelineCallerThread.set(null);
        }
    }

    @Override
    public Void call() {
        this.call(null);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void managedCall(IN input) {
        PipelineStage p = this.pipelineStages[0];
        this.currentPipelineCallerThread.lazySet(Thread.currentThread());
        try {
            this.state.lazySet(State.RUNNING);
            Object id = this.getId();
            try {
                this.doCall(input, p, id);
            }
            finally {
                this.state.lazySet(State.IDLE);
            }
        }
        finally {
            this.currentPipelineCallerThread.lazySet(null);
        }
    }

    private void doCall(IN input, PipelineStage<IN, ?> stage, Object id) {
        try {
            log.trace("Pipeline [{}] call starting with input [{}]", id, input);
            if (stage instanceof Countable) {
                ((Countable)stage).incrementCount();
            }
            stage.process(input);
            log.trace("Pipeline [{}] call completed", id);
        }
        catch (Throwable t) {
            if (this.state.get() != State.RUNNING && Throwables.getRootCause((Throwable)t) instanceof InterruptedException) {
                log.debug("Pipeline [" + String.valueOf(id) + "] call was interrupted", t);
            }
            log.error("Pipeline [" + String.valueOf(id) + "] call exited abruptly", t);
            throw t;
        }
    }

    public void stop() {
        Thread executor;
        log.debug("Stopping pipeline [{}]", this.getId());
        this.state.set(State.AWAITING_IDLE);
        while ((executor = this.currentPipelineCallerThread.get()) != null) {
            log.debug("Pipeline thread [{}] will be interrupted", (Object)executor.getName());
            executor.interrupt();
            try {
                log.debug("Waiting for pipeline thread [{}] to complete", (Object)executor.getName());
                Thread.sleep(5L);
            }
            catch (InterruptedException e) {
                log.warn("Pipeline stop has been interrupted. Abandoning pipeline stop", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
        LifecycleHelper.stopAll(Arrays.asList(this.pipelineStages));
        this.state.set(State.STOPPED);
        log.info("Stopped pipeline [{}]", this.getId());
    }

    public void pause() {
        PipelineStage firstStage = this.pipelineStages[0];
        if (!(firstStage instanceof Pausable)) {
            throw new UnsupportedOperationException("Pipeline with id [" + String.valueOf(this.getId()) + "] does not support pause functionality");
        }
        ((Pausable)firstStage).pause();
    }

    public void resume() {
        PipelineStage firstStage = this.pipelineStages[0];
        if (!(firstStage instanceof Pausable)) {
            throw new UnsupportedOperationException("Pipeline with id [" + String.valueOf(this.getId()) + "] does not support resume functionality");
        }
        ((Pausable)firstStage).resume();
    }

    public String getDisplayState() {
        PipelineStage firstStage;
        State currentState = this.getState();
        if (currentState == State.RUNNING && (firstStage = this.pipelineStages[0]) instanceof Pausable) {
            return ((Pausable)firstStage).isPaused() ? "PAUSED" : State.RUNNING.toString();
        }
        return currentState.toString();
    }

    public String toString() {
        return "Pipeline{id=" + String.valueOf(this.getId()) + "}";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pipeline)) {
            return false;
        }
        Pipeline other = (Pipeline)o;
        Object this$pipelineId = this.pipelineId;
        Object other$pipelineId = other.pipelineId;
        return !(this$pipelineId == null ? other$pipelineId != null : !this$pipelineId.equals(other$pipelineId));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Object $pipelineId = this.pipelineId;
        result = result * 59 + ($pipelineId == null ? 43 : $pipelineId.hashCode());
        return result;
    }

    public static enum State {
        CREATED,
        IDLE,
        RUNNING,
        AWAITING_IDLE,
        STOPPED;

    }
}

