/*
 * Decompiled with CFR 0.152.
 */
package com.appdynamics.analytics.message.util;

import com.appdynamics.analytics.message.api.MessagePack;
import com.google.common.base.Preconditions;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MpscMessagePacks<SRC_ID, MSG> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MpscMessagePacks.class);
    private final int maximumExpectedProducers;
    private final ThreadLocal<Container<SRC_ID, MSG>> tlsMsgPacks;
    private final BlockingQueue<Container<SRC_ID, MSG>> pickUpQueue;

    public MpscMessagePacks(int maximumExpectedProducers) {
        this.maximumExpectedProducers = maximumExpectedProducers;
        this.tlsMsgPacks = new ThreadLocal();
        this.pickUpQueue = new ArrayBlockingQueue<Container<SRC_ID, MSG>>(maximumExpectedProducers * 2);
    }

    BlockingQueue<Container<SRC_ID, MSG>> getPickUpQueue() {
        return this.pickUpQueue;
    }

    public void offer(MessagePack<SRC_ID, MSG> messagePack) {
        Container<SRC_ID, MSG> container = this.tlsMsgPacks.get();
        if (container == null) {
            container = new Container<SRC_ID, MSG>(messagePack);
            this.tlsMsgPacks.set(container);
        } else if (container.messagePack != messagePack) {
            log.warn("It appears that another message pack was used on this thread and it was not retired before this new message pack was offered");
        }
        this.offerNonEmptyPack(container);
    }

    public void retireProducer() {
        this.internalRetireProducer();
    }

    MessagePack<SRC_ID, MSG> internalRetireProducer() {
        Container<SRC_ID, MSG> container = this.tlsMsgPacks.get();
        this.tlsMsgPacks.remove();
        return container == null ? null : container.messagePack;
    }

    private void offerNonEmptyPack(Container<SRC_ID, MSG> containerWithNonEmptyPack) {
        if (containerWithNonEmptyPack.waitingForPickup.compareAndSet(false, true)) {
            int i = 0;
            while (!this.pickUpQueue.offer(containerWithNonEmptyPack)) {
                if (i % 10 == 0) {
                    log.warn("Internal queue appears to be full [{}]. There appear to be moreproducers than the initial, expected number of producers [{}]", (Object)this.pickUpQueue.size(), (Object)this.maximumExpectedProducers);
                }
                ++i;
            }
        }
    }

    public MessagePack<SRC_ID, MSG> consume() throws InterruptedException {
        Container<SRC_ID, MSG> container = this.internalPickUp();
        return container.messagePack;
    }

    Container<SRC_ID, MSG> internalPickUp() throws InterruptedException {
        Container<SRC_ID, MSG> container;
        while ((container = this.pickUpQueue.poll(1L, TimeUnit.SECONDS)) == null && !Thread.currentThread().isInterrupted()) {
        }
        if (container != null) {
            container.waitingForPickup.set(false);
            this.tlsMsgPacks.set(container);
        }
        return container;
    }

    public void afterConsume() {
        Container<SRC_ID, MSG> container = this.tlsMsgPacks.get();
        Preconditions.checkArgument((container != null ? 1 : 0) != 0, (Object)"This thread has not consumed a message pack recently");
        this.tlsMsgPacks.remove();
        if (container.messagePack.size() > 0) {
            this.offerNonEmptyPack(container);
        }
    }

    static class Container<SRC_ID, MSG> {
        private final MessagePack<SRC_ID, MSG> messagePack;
        private final AtomicBoolean waitingForPickup = new AtomicBoolean();

        private Container(MessagePack<SRC_ID, MSG> messagePack) {
            this.messagePack = messagePack;
        }

        MessagePack<SRC_ID, MSG> getMessagePack() {
            return this.messagePack;
        }

        boolean isWaitingForPickup() {
            return this.waitingForPickup.get();
        }
    }
}

