/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.beans.events;

import com.google.common.collect.Maps;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.EventCorrelationType;
import com.singularity.ee.controller.api.constants.EventType;
import com.singularity.ee.controller.api.constants.NotificationSeverity;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.EventCorrelationKey;
import com.singularity.ee.controller.api.dto.EventDetails;
import com.singularity.ee.controller.api.dto.EventSummary;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.NameValuePairType;
import com.singularity.ee.controller.api.dto.TypedNameValuePair;
import com.singularity.ee.controller.api.dto.UserComment;
import com.singularity.ee.controller.api.exceptions.IllegalObjectStateException;
import com.singularity.ee.events.AgentEventData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;

public class EventInternal
implements Serializable {
    private static final Logger logger = Logger.getLogger(EventInternal.class.getName());
    private Long id = 0L;
    private EventType eventType;
    private long eventTime;
    private NotificationSeverity severity = NotificationSeverity.INFO;
    private String eventSummary;
    private long endTime;
    private String guid;
    private String subType;
    private EntityDefinition triggeredEntity;
    private Map<String, String> eventDetails = Collections.emptyMap();
    private Map<EntityType, Set<Long>> affectedEntities = new HashMap<EntityType, Set<Long>>();
    private Map<EventCorrelationType, Set<String>> correlationKeys = new HashMap<EventCorrelationType, Set<String>>();
    private boolean archived;
    private Map<String, Object> eventProperties = Collections.emptyMap();
    private List<UserComment> userComments = Collections.emptyList();

    public EventSummary convertToEventSummary() {
        EventSummary result = new EventSummary();
        result.setEndTime(this.endTime);
        result.setId(this.id.longValue());
        ArrayList<EntityDefinition> affectedEntityList = new ArrayList<EntityDefinition>();
        for (EntityType entityType : this.affectedEntities.keySet()) {
            Set<Long> entityIds = this.affectedEntities.get(entityType);
            Iterator<Long> iterator = entityIds.iterator();
            while (iterator.hasNext()) {
                Long entityId = iterator.next();
                affectedEntityList.add(new EntityDefinition(entityType, entityId.longValue()));
            }
        }
        EntityDefinition[] affectedEntities = new EntityDefinition[affectedEntityList.size()];
        affectedEntities = affectedEntityList.toArray(affectedEntities);
        result.setAffectedEntities(affectedEntities);
        result.setArchived(this.isArchived());
        ArrayList<EventCorrelationKey> correlationKeysList = new ArrayList<EventCorrelationKey>();
        for (EventCorrelationType eventCorrelationType : this.correlationKeys.keySet()) {
            Set<String> values = this.correlationKeys.get(eventCorrelationType);
            Iterator<String> iterator = values.iterator();
            while (iterator.hasNext()) {
                String value = iterator.next();
                EventCorrelationKey correlationKey = new EventCorrelationKey();
                correlationKey.setCorrelationType(eventCorrelationType);
                correlationKey.setCorrelationValue(value);
                correlationKeysList.add(correlationKey);
            }
        }
        EventCorrelationKey[] correlationKeys = new EventCorrelationKey[correlationKeysList.size()];
        correlationKeys = correlationKeysList.toArray(correlationKeys);
        result.setCorrelationKeys(correlationKeys);
        result.setEventSummary(this.eventSummary);
        result.setEventTime(new Date(this.eventTime));
        result.setEventType(this.eventType);
        result.setGuid(this.guid);
        result.setSeverity(this.severity);
        result.setSubType(this.subType);
        result.setTriggeredEntity(this.triggeredEntity);
        ArrayList<NameValuePair> details = new ArrayList<NameValuePair>();
        for (Map.Entry entry : this.eventDetails.entrySet()) {
            details.add(new NameValuePair((String)entry.getKey(), (String)entry.getValue()));
        }
        result.setDetails(details.toArray(new NameValuePair[details.size()]));
        ArrayList<TypedNameValuePair> propertiesList = new ArrayList<TypedNameValuePair>();
        for (String name : this.eventProperties.keySet()) {
            Object value = this.eventProperties.get(name);
            TypedNameValuePair property = new TypedNameValuePair();
            property.setName(name);
            if (value != null) {
                if (value instanceof String) {
                    property.setType(NameValuePairType.STRING);
                    property.setStringValue((String)value);
                } else if (value instanceof Long) {
                    property.setType(NameValuePairType.LONG);
                    property.setLongValue((Long)value);
                } else {
                    logger.warning("Unexpected property value: " + value + " observed for property: " + name + " in the given EventInternal instance.");
                }
            } else {
                property.setType(NameValuePairType.STRING);
            }
            propertiesList.add(property);
        }
        TypedNameValuePair[] typedNameValuePairArray2 = new TypedNameValuePair[propertiesList.size()];
        typedNameValuePairArray2 = propertiesList.toArray(typedNameValuePairArray2);
        result.setProperties(typedNameValuePairArray2);
        return result;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public boolean isArchived() {
        return this.archived;
    }

    public void setArchived(boolean archived) {
        this.archived = archived;
    }

    public void addAffectedEntity(EntityType entityType, long entityId) {
        Set<Long> ids = this.getIdsForEntityType(entityType);
        ids.add(entityId);
    }

    public void addCorrelationKey(EventCorrelationType correlationType, String correlationValue) {
        Set<String> values = this.getValuesForEventCorrelationType(correlationType);
        if (correlationValue == null) {
            throw new NullPointerException("event correlation value is null");
        }
        values.add(correlationValue);
    }

    private Set<Long> getIdsForEntityType(EntityType entityType) {
        if (entityType == null) {
            throw new NullPointerException("entity type is null");
        }
        Set<Long> ids = this.affectedEntities.get(entityType);
        if (ids == null) {
            ids = new HashSet<Long>();
            this.affectedEntities.put(entityType, ids);
        }
        return ids;
    }

    private Set<String> getValuesForEventCorrelationType(EventCorrelationType correlationType) {
        if (correlationType == null) {
            throw new NullPointerException("event correlation type is null");
        }
        Set<String> values = this.correlationKeys.get(correlationType);
        if (values == null) {
            values = new HashSet<String>();
            this.correlationKeys.put(correlationType, values);
        }
        return values;
    }

    public int getNumAffectedEntities() {
        int num = 0;
        for (Set<Long> entitiesOfType : this.affectedEntities.values()) {
            num += entitiesOfType.size();
        }
        return num;
    }

    public Map<EntityType, Set<Long>> getAffectedEntities() {
        return Collections.unmodifiableMap(this.affectedEntities);
    }

    public void setAffectedEntities(Map<EntityType, Set<Long>> affectedEntities) {
        if (affectedEntities != null) {
            if (this.affectedEntities.isEmpty()) {
                this.affectedEntities = affectedEntities;
            } else {
                for (Map.Entry<EntityType, Set<Long>> entry : affectedEntities.entrySet()) {
                    EntityType entityType = entry.getKey();
                    Set<Long> ids = entry.getValue();
                    Set<Long> existingIds = this.getIdsForEntityType(entityType);
                    existingIds.addAll(ids);
                }
            }
        }
    }

    public int getNumCorrelationKeys() {
        int num = 0;
        for (Set<String> keysOfType : this.correlationKeys.values()) {
            num += keysOfType.size();
        }
        return num;
    }

    public Map<EventCorrelationType, Set<String>> getCorrelationKeys() {
        return Collections.unmodifiableMap(this.correlationKeys);
    }

    public void setCorrelationKeys(Map<EventCorrelationType, Set<String>> correlationKeys) {
        if (correlationKeys != null) {
            if (this.correlationKeys.isEmpty()) {
                this.correlationKeys = correlationKeys;
            } else {
                for (Map.Entry<EventCorrelationType, Set<String>> entry : correlationKeys.entrySet()) {
                    EventCorrelationType correlationType = entry.getKey();
                    Set<String> values = entry.getValue();
                    Set<String> existingValues = this.getValuesForEventCorrelationType(correlationType);
                    existingValues.addAll(values);
                }
            }
        }
    }

    public Map<String, String> getEventDetails() {
        return this.eventDetails;
    }

    public void setEventDetails(Map<String, String> eventDetails) {
        if (eventDetails != null) {
            this.eventDetails = eventDetails;
        }
    }

    public EventType getEventType() {
        return this.eventType;
    }

    public void setEventType(EventType eventType) {
        this.eventType = eventType;
    }

    public long getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(long eventTime) {
        this.eventTime = eventTime;
    }

    public NotificationSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(NotificationSeverity severity) {
        if (severity != null) {
            this.severity = severity;
        }
    }

    public String getEventSummary() {
        return this.eventSummary;
    }

    public void setEventSummary(String eventSummary) {
        this.eventSummary = eventSummary;
    }

    public void fromExternalDTOs(EventSummary eventSummary, EventDetails eventDetails) throws IllegalObjectStateException {
        TypedNameValuePair[] properties;
        this.setId(eventSummary.getId());
        this.setEndTime(eventSummary.getEndTime());
        EventType eventType = eventSummary.getEventType();
        if (eventType == null) {
            throw new IllegalObjectStateException("event type is not specified");
        }
        this.setEventType(eventType);
        Date eventTime = eventSummary.getEventTime();
        if (eventTime == null) {
            throw new IllegalObjectStateException("event time is not specified");
        }
        this.setEventTime(eventTime.getTime());
        this.setEndTime(eventSummary.getEndTime());
        this.setSeverity(eventSummary.getSeverity());
        String summary = eventSummary.getEventSummary();
        if (summary == null) {
            throw new IllegalObjectStateException("event summary string is not specified");
        }
        this.setEventSummary(summary);
        this.setAffectedEntities(EntityDefinition.convertEntityDefinitionsToMap((EntityDefinition[])eventSummary.getAffectedEntities()));
        this.setTriggeredEntity(eventSummary.getTriggeredEntity());
        this.setCorrelationKeys(EventCorrelationKey.convertCorrelationKeysToMap((EventCorrelationKey[])eventSummary.getCorrelationKeys()));
        if (eventDetails != null) {
            this.setEventDetails(NameValuePair.convertNameValuePairsToMap((NameValuePair[])eventDetails.getEventDetails()));
        }
        this.setArchived(eventSummary.isArchived());
        String guid = eventSummary.getGuid();
        if (guid == null) {
            guid = UUID.randomUUID().toString();
        }
        this.setGuid(guid);
        if (eventSummary.getSubType() != null) {
            this.setSubType(eventSummary.getSubType());
        }
        if ((properties = eventSummary.getProperties()) != null) {
            HashMap<String, Object> eventProperties = new HashMap<String, Object>();
            for (TypedNameValuePair nvp : properties) {
                if (nvp.getType() == NameValuePairType.LONG) {
                    eventProperties.put(nvp.getName(), nvp.getLongValue());
                    continue;
                }
                eventProperties.put(nvp.getName(), nvp.getStringValue());
            }
            this.setEventProperties(eventProperties);
        }
    }

    public void fromAgentEventData(AgentEventData eventData, Map<EntityType, Set<Long>> affectedEntities, Map<EventCorrelationType, Set<String>> correlationKeys) {
        switch (eventData.getType()) {
            case ALERT: 
            case SYSTEM_LOG: {
                throw new IllegalStateException(eventData.getType() + " events should not be generated by agents. This event type is generated within the controller only!");
            }
        }
        this.setEventSummary(eventData.getSummary());
        this.setEventTime(eventData.getTimestamp());
        this.setEventType(eventData.getType());
        this.setSeverity(eventData.getNotificationSeverity());
        this.setAffectedEntities(affectedEntities);
        this.setCorrelationKeys(correlationKeys);
        this.setEventDetails(eventData.getEventDetails());
        this.setEventProperties(eventData.getEventProperties());
        this.setArchived(eventData.isArchived());
        this.setTriggeredEntity(eventData.getTriggeredEntity());
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public EntityDefinition getTriggeredEntity() {
        return this.triggeredEntity;
    }

    public void setTriggeredEntity(EntityDefinition triggeredEntity) {
        this.triggeredEntity = triggeredEntity;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public Map<String, Object> getEventProperties() {
        return this.eventProperties;
    }

    public Map<String, Object> getCustomEventProperties() {
        HashMap map = Maps.newHashMap(this.eventProperties);
        map.put("severity", this.getSeverity());
        return map;
    }

    public void setEventProperties(Map<String, Object> eventProperties) {
        if (eventProperties != null) {
            this.eventProperties = eventProperties;
        }
    }

    public void setUserComments(List<UserComment> userComments) {
        if (userComments != null) {
            this.userComments = userComments;
        }
    }

    public List<UserComment> getUserComments() {
        return this.userComments;
    }
}

