/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.beans.events;

import com.singularity.ee.controller.beans.events.AEvent;
import com.singularity.ee.controller.beans.events.ApplicationMetricTreeEventType;
import com.singularity.ee.controller.beans.events.EventContext;
import com.singularity.ee.controller.beans.events.IEventHandler;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AEventHandler<T extends AEvent, E extends EventContext<T>>
implements IEventHandler<T> {
    protected static final Logger logger = Logger.getLogger("com.appdynamics.EVENTS.PROCESSING");
    private final ThreadLocal<E> eventContext = new ThreadLocal();
    public static final String ENTITY_ADDED_EVENT = "added";
    protected static final String ENTITY_DELETED_EVENT = "deleted";
    protected static final String ENTITY_RENAMED_EVENT = "renamed";
    protected static final String ENTITY_UPDATED_EVENT = "updated";
    protected static final String ON_BEFORE_HANDLE_EVENT = "On Before Handle";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void handleEvent(T event) throws Exception {
        E context = this.createEventContext(event);
        if (context == null) {
            return;
        }
        this.setEventContext(context);
        ApplicationMetricTreeEventType type = ((AEvent)event).getType();
        try {
            switch (type) {
                case ADD: {
                    this.onEntityAddedEvent();
                    return;
                }
                case DELETE: {
                    this.onEntityDeletedEvent();
                    return;
                }
                case RENAME: {
                    this.onEntityRenamedEvent();
                    return;
                }
                case UPDATE: {
                    this.onEntityUpdatedEvent();
                    return;
                }
            }
            return;
        }
        finally {
            this.onEventContextTearDown(context);
            this.setEventContext(null);
        }
    }

    protected abstract E createEventContext(T var1);

    protected abstract void onEventContextTearDown(E var1);

    protected void onEntityAddedEvent() throws Exception {
    }

    protected void onEntityDeletedEvent() throws Exception {
    }

    protected void onEntityRenamedEvent() throws Exception {
    }

    protected void onEntityUpdatedEvent() throws Exception {
    }

    @Override
    public void onBeforeHandleEvent(T event) {
    }

    public final E getEventContext() {
        return (E)((EventContext)this.eventContext.get());
    }

    public final void setEventContext(E context) {
        this.eventContext.set(context);
    }

    public final void logEntityNotFound(String entityName, long entityId, String eventName) {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(entityName + " id:" + entityId + " not found for entity [" + eventName + "] event in " + this.getClass().getSimpleName());
        }
    }
}

