/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.beans.events;

import com.singularity.ee.controller.beans.events.ApplicationMetricTreeEventType;
import com.singularity.ee.controller.beans.events.IEvent;
import com.singularity.ee.controller.beans.events.IEventHandler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AEvent
implements IEvent {
    private final Map<Class<? extends IEventHandler>, Object> eventHandlerPayload = Collections.synchronizedMap(new HashMap());
    private final ApplicationMetricTreeEventType type;
    private final long applicationId;
    private final long accountId;

    protected AEvent(ApplicationMetricTreeEventType type, long accountId, long applicationId) {
        this.type = type;
        this.accountId = accountId;
        this.applicationId = applicationId;
    }

    @Override
    public final ApplicationMetricTreeEventType getType() {
        return this.type;
    }

    @Override
    public long getApplicationId() {
        return this.applicationId;
    }

    @Override
    public long getAccountId() {
        return this.accountId;
    }

    @Override
    public boolean isAdd() {
        return this.type == ApplicationMetricTreeEventType.ADD;
    }

    @Override
    public boolean isDelete() {
        return this.type == ApplicationMetricTreeEventType.DELETE;
    }

    @Override
    public boolean isRename() {
        return this.type == ApplicationMetricTreeEventType.RENAME;
    }

    @Override
    public boolean handleSynchronously() {
        return false;
    }

    @Override
    public final void addPayload(Class<? extends IEventHandler> processingHandlerType, Object payload) {
        this.eventHandlerPayload.put(processingHandlerType, payload);
    }

    @Override
    public final Object getPayload(Class<? extends IEventHandler> processingHandlerType) {
        return this.eventHandlerPayload.get(processingHandlerType);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ", application Id: " + this.getApplicationId() + ", type: " + this.getType();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AEvent)) {
            return false;
        }
        AEvent other = (AEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getApplicationId() != other.getApplicationId()) {
            return false;
        }
        if (this.getAccountId() != other.getAccountId()) {
            return false;
        }
        Map<Class<? extends IEventHandler>, Object> this$eventHandlerPayload = this.eventHandlerPayload;
        Map<Class<? extends IEventHandler>, Object> other$eventHandlerPayload = other.eventHandlerPayload;
        if (this$eventHandlerPayload == null ? other$eventHandlerPayload != null : !((Object)this$eventHandlerPayload).equals(other$eventHandlerPayload)) {
            return false;
        }
        ApplicationMetricTreeEventType this$type = this.getType();
        ApplicationMetricTreeEventType other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AEvent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $applicationId = this.getApplicationId();
        result = result * 59 + (int)($applicationId >>> 32 ^ $applicationId);
        long $accountId = this.getAccountId();
        result = result * 59 + (int)($accountId >>> 32 ^ $accountId);
        Map<Class<? extends IEventHandler>, Object> $eventHandlerPayload = this.eventHandlerPayload;
        result = result * 59 + ($eventHandlerPayload == null ? 43 : ((Object)$eventHandlerPayload).hashCode());
        ApplicationMetricTreeEventType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }
}

