/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.util.dbmon;

import com.appdynamics.dbmon.api.dtos.BlockStateMeasurement;
import com.appdynamics.dbmon.api.dtos.BucketStatMeasurement;
import com.appdynamics.dbmon.api.dtos.BucketStatType;
import com.appdynamics.dbmon.api.dtos.CustomJdbcConnectionProperty;
import com.appdynamics.dbmon.api.dtos.DBMonitorConfig;
import com.appdynamics.dbmon.api.dtos.DBMonitorConfigProperty;
import com.appdynamics.dbmon.api.dtos.DBServer;
import com.appdynamics.dbmon.api.dtos.DBServerSatelliteEntityType;
import com.appdynamics.dbmon.api.dtos.DBServerSatelliteV2;
import com.appdynamics.dbmon.api.dtos.DBSqlServerAvailabilityGroupDTO;
import com.appdynamics.dbmon.api.dtos.DBSqlServerAvailabilityGroupDatabaseDTO;
import com.appdynamics.dbmon.api.dtos.DBSqlServerAvailabilityReplicaDTO;
import com.appdynamics.dbmon.api.dtos.DBSqlServerClusterDTO;
import com.appdynamics.dbmon.api.dtos.QueryStatMeasurement;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.primitives.Longs;
import com.singularity.ee.controller.api.constants.DBMonitorConstants;
import com.singularity.ee.controller.api.dto.APersistentObject;
import com.singularity.ee.controller.api.dto.dbmon.DBAppName;
import com.singularity.ee.controller.api.dto.dbmon.DBClient;
import com.singularity.ee.controller.api.dto.dbmon.DBCustomEventCriteriaType;
import com.singularity.ee.controller.api.dto.dbmon.DBCustomEventType;
import com.singularity.ee.controller.api.dto.dbmon.DBHostOS;
import com.singularity.ee.controller.api.dto.dbmon.DBModule;
import com.singularity.ee.controller.api.dto.dbmon.DBNamespace;
import com.singularity.ee.controller.api.dto.dbmon.DBProgram;
import com.singularity.ee.controller.api.dto.dbmon.DBSchema;
import com.singularity.ee.controller.api.dto.dbmon.DBServerRole;
import com.singularity.ee.controller.api.dto.dbmon.DBServerSatellite;
import com.singularity.ee.controller.api.dto.dbmon.DBServerType;
import com.singularity.ee.controller.api.dto.dbmon.DBSession;
import com.singularity.ee.controller.api.dto.dbmon.DBSqlServerAvailabilityGroup;
import com.singularity.ee.controller.api.dto.dbmon.DBSqlServerCluster;
import com.singularity.ee.controller.api.dto.dbmon.DBSqlServerDatabase;
import com.singularity.ee.controller.api.dto.dbmon.DBSqlServerDatabaseFile;
import com.singularity.ee.controller.api.dto.dbmon.DBSqlServerFilegroup;
import com.singularity.ee.controller.api.dto.dbmon.DBSqlServerLogFile;
import com.singularity.ee.controller.api.dto.dbmon.DBWaitState;
import com.singularity.ee.controller.api.dto.dbmon.ExtraProperty;
import com.singularity.ee.controller.api.dto.dbmon.MetaDataProperty;
import com.singularity.ee.controller.api.dto.dbmon.QueryPlan;
import com.singularity.ee.controller.api.dto.dbmon.SQLQuery;
import com.singularity.ee.controller.api.dto.dbmon.WaitTimeMeasurement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class DBMonServiceUtil {
    @VisibleForTesting
    public static final String REDACTED_SECERET_DISPLAY_STRING = "appdynamics_redacted_password";

    public static List<com.appdynamics.dbmon.api.dtos.DBWaitState> controllerToDBMon(DBWaitState[] waitStates) {
        if (waitStates == null) {
            return Collections.emptyList();
        }
        ArrayList<com.appdynamics.dbmon.api.dtos.DBWaitState> returnList = new ArrayList<com.appdynamics.dbmon.api.dtos.DBWaitState>(waitStates.length);
        for (DBWaitState waitState : waitStates) {
            returnList.add(DBMonServiceUtil.controllerToDBMon(waitState));
        }
        return returnList;
    }

    public static List<com.appdynamics.dbmon.api.dtos.DBSqlServerDatabase> controllerToDBMon(DBSqlServerDatabase[] dbSqlServerDatabases) {
        if (dbSqlServerDatabases == null) {
            return Collections.emptyList();
        }
        return Arrays.stream(dbSqlServerDatabases).map(DBMonServiceUtil::controllerToDBMon).collect(Collectors.toList());
    }

    public static com.appdynamics.dbmon.api.dtos.DBSqlServerDatabase controllerToDBMon(DBSqlServerDatabase dbSqlServerDatabase) {
        if (dbSqlServerDatabase == null) {
            return null;
        }
        return new com.appdynamics.dbmon.api.dtos.DBSqlServerDatabase(dbSqlServerDatabase.getId(), dbSqlServerDatabase.getName(), dbSqlServerDatabase.getState(), dbSqlServerDatabase.getDbServerId(), DBMonServiceUtil.controllerToDBMon(dbSqlServerDatabase.getFilegroups().toArray(new DBSqlServerFilegroup[0])), DBMonServiceUtil.controllerToDBMon(dbSqlServerDatabase.getLogFiles().toArray(new DBSqlServerLogFile[0])));
    }

    public static Set<com.appdynamics.dbmon.api.dtos.DBSqlServerLogFile> controllerToDBMon(DBSqlServerLogFile[] dbSqlServerLogFiles) {
        if (dbSqlServerLogFiles == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(dbSqlServerLogFiles).map(DBMonServiceUtil::controllerToDBMon).collect(Collectors.toSet());
    }

    private static com.appdynamics.dbmon.api.dtos.DBSqlServerLogFile controllerToDBMon(DBSqlServerLogFile dbSqlServerLogFile) {
        if (dbSqlServerLogFile == null) {
            return null;
        }
        return new com.appdynamics.dbmon.api.dtos.DBSqlServerLogFile(dbSqlServerLogFile.getId(), dbSqlServerLogFile.getName(), dbSqlServerLogFile.getState(), dbSqlServerLogFile.getPath(), dbSqlServerLogFile.isAutoGrow(), dbSqlServerLogFile.getRemainingGrowthIncrements(), dbSqlServerLogFile.getGrowthIncrementUnit(), dbSqlServerLogFile.getMaxSize(), dbSqlServerLogFile.getIsPercentGrowth());
    }

    public static Set<com.appdynamics.dbmon.api.dtos.DBSqlServerFilegroup> controllerToDBMon(DBSqlServerFilegroup[] dbSqlServerFilegroups) {
        if (dbSqlServerFilegroups == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(dbSqlServerFilegroups).map(DBMonServiceUtil::controllerToDBMon).collect(Collectors.toSet());
    }

    public static com.appdynamics.dbmon.api.dtos.DBSqlServerFilegroup controllerToDBMon(DBSqlServerFilegroup dbSqlServerFilegroup) {
        if (dbSqlServerFilegroup == null) {
            return null;
        }
        return new com.appdynamics.dbmon.api.dtos.DBSqlServerFilegroup(dbSqlServerFilegroup.getId(), dbSqlServerFilegroup.getName(), dbSqlServerFilegroup.getType(), dbSqlServerFilegroup.getState(), DBMonServiceUtil.controllerToDBMon(dbSqlServerFilegroup.getDatabaseFiles().toArray(new DBSqlServerDatabaseFile[0])));
    }

    public static Set<com.appdynamics.dbmon.api.dtos.DBSqlServerDatabaseFile> controllerToDBMon(DBSqlServerDatabaseFile[] dbSqlServerDatabaseFiles) {
        if (dbSqlServerDatabaseFiles == null) {
            return Collections.emptySet();
        }
        return Arrays.stream(dbSqlServerDatabaseFiles).map(DBMonServiceUtil::controllerToDBMon).collect(Collectors.toSet());
    }

    public static com.appdynamics.dbmon.api.dtos.DBSqlServerDatabaseFile controllerToDBMon(DBSqlServerDatabaseFile dbSqlServerDatabaseFile) {
        if (dbSqlServerDatabaseFile == null) {
            return null;
        }
        return new com.appdynamics.dbmon.api.dtos.DBSqlServerDatabaseFile(dbSqlServerDatabaseFile.getId(), dbSqlServerDatabaseFile.getName(), dbSqlServerDatabaseFile.getType(), dbSqlServerDatabaseFile.getState(), dbSqlServerDatabaseFile.getPath(), dbSqlServerDatabaseFile.isAutoGrow(), dbSqlServerDatabaseFile.getRemainingGrowthIncrements(), dbSqlServerDatabaseFile.getGrowthIncrementUnit(), dbSqlServerDatabaseFile.getMaxSize(), dbSqlServerDatabaseFile.getIsPercentGrowth());
    }

    public static com.appdynamics.dbmon.api.dtos.DBWaitState controllerToDBMon(DBWaitState waitState) {
        if (waitState == null) {
            return null;
        }
        return new com.appdynamics.dbmon.api.dtos.DBWaitState(waitState.getId(), waitState.getName(), waitState.getDbType().name());
    }

    public static com.appdynamics.dbmon.api.dtos.DBServerType controllerToDBMon(DBServerType dbType) {
        if (dbType == null) {
            return null;
        }
        return com.appdynamics.dbmon.api.dtos.DBServerType.valueOf(dbType.name());
    }

    public static com.appdynamics.dbmon.api.dtos.DBServerType[] controllerToDBMon(DBServerType[] dbTypes) {
        if (dbTypes == null || dbTypes.length == 0) {
            return new com.appdynamics.dbmon.api.dtos.DBServerType[0];
        }
        LinkedList<com.appdynamics.dbmon.api.dtos.DBServerType> returnList = new LinkedList<com.appdynamics.dbmon.api.dtos.DBServerType>();
        for (DBServerType type : dbTypes) {
            returnList.add(com.appdynamics.dbmon.api.dtos.DBServerType.valueOf(type.name()));
        }
        return returnList.toArray(new com.appdynamics.dbmon.api.dtos.DBServerType[returnList.size()]);
    }

    public static List<DBSqlServerClusterDTO> controllerToDBMon(DBSqlServerCluster[] clusters) {
        return Arrays.stream(clusters).map(cluster -> new DBSqlServerClusterDTO(cluster.getDbConfigId(), cluster.getClusterName(), cluster.getQuorumType(), cluster.getQuorumState())).collect(Collectors.toList());
    }

    public static List<DBSqlServerAvailabilityGroupDTO> controllerToDBMon(DBSqlServerAvailabilityGroup[] availabilityGroups) {
        return Arrays.stream(availabilityGroups).map(availabilityGroup -> {
            DBSqlServerAvailabilityGroupDTO model = new DBSqlServerAvailabilityGroupDTO(availabilityGroup.getAgId(), availabilityGroup.getAgName(), availabilityGroup.getDbConfigId(), availabilityGroup.getMetadata(), availabilityGroup.getReportedByDbServerId());
            if (availabilityGroup.getReplicas() != null) {
                Set<DBSqlServerAvailabilityReplicaDTO> replicaModels = availabilityGroup.getReplicas().stream().map(replica -> new DBSqlServerAvailabilityReplicaDTO(replica.getReplicaId(), replica.getReplicaName(), replica.getReplicaRole(), replica.getMetadata())).collect(Collectors.toSet());
                model.setReplicas(replicaModels);
            }
            if (availabilityGroup.getDatabases() != null) {
                Set<DBSqlServerAvailabilityGroupDatabaseDTO> databaseModels = availabilityGroup.getDatabases().stream().map(database -> new DBSqlServerAvailabilityGroupDatabaseDTO(database.getReplicaId(), database.getDatabaseId(), database.getDatabaseName(), database.getDatabaseRole(), database.getMetadata())).collect(Collectors.toSet());
                model.setDatabases(databaseModels);
            }
            return model;
        }).collect(Collectors.toList());
    }

    public static List<com.appdynamics.dbmon.api.dtos.SQLQuery> controllerToDBMon(SQLQuery[] queries) {
        if (queries == null) {
            return Collections.emptyList();
        }
        LinkedList<com.appdynamics.dbmon.api.dtos.SQLQuery> returnList = new LinkedList<com.appdynamics.dbmon.api.dtos.SQLQuery>();
        for (SQLQuery query : queries) {
            returnList.add(DBMonServiceUtil.controllerToDBMon(query));
        }
        return returnList;
    }

    public static com.appdynamics.dbmon.api.dtos.SQLQuery controllerToDBMon(SQLQuery query) {
        if (query == null) {
            return null;
        }
        String queryText = query.getQueryText();
        String queryHashCode = query.getQueryHashCode();
        String queryJavaHashCode = query.getQueryJavaHashCode();
        String displayName = query.getDisplayName();
        String groupId = query.getGroupId();
        com.appdynamics.dbmon.api.dtos.SQLQuery dbmonQuery = new com.appdynamics.dbmon.api.dtos.SQLQuery(0L, queryText, displayName, queryHashCode, queryJavaHashCode, groupId);
        dbmonQuery.setDbType(DBMonServiceUtil.controllerToDBMon(query.getDbType()));
        return dbmonQuery;
    }

    public static List<com.appdynamics.dbmon.api.dtos.QueryPlan> controllerToDBMon(QueryPlan[] queryPlans) {
        if (queryPlans == null) {
            return Collections.emptyList();
        }
        LinkedList<com.appdynamics.dbmon.api.dtos.QueryPlan> returnList = new LinkedList<com.appdynamics.dbmon.api.dtos.QueryPlan>();
        for (QueryPlan queryPlan : queryPlans) {
            returnList.add(DBMonServiceUtil.controllerToDBMon(queryPlan));
        }
        return returnList;
    }

    public static com.appdynamics.dbmon.api.dtos.QueryPlan controllerToDBMon(QueryPlan queryPlan) {
        if (queryPlan == null) {
            return null;
        }
        String queryPlanHash = queryPlan.getQueryPlanHash();
        long dbServerId = queryPlan.getDbServerId();
        String queryPlanText = queryPlan.getQueryPlanText();
        com.appdynamics.dbmon.api.dtos.QueryPlan dbmonQueryPlan = new com.appdynamics.dbmon.api.dtos.QueryPlan(0L, queryPlanHash, dbServerId, queryPlanText);
        return dbmonQueryPlan;
    }

    public static List<DBServer> controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.DBServer[] servers) {
        if (servers == null) {
            return Collections.emptyList();
        }
        ArrayList<DBServer> returnList = new ArrayList<DBServer>(servers.length);
        for (com.singularity.ee.controller.api.dto.dbmon.DBServer server : servers) {
            returnList.add(DBMonServiceUtil.controllerToDBMon(server));
        }
        return returnList;
    }

    public static DBServer controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.DBServer server) {
        if (server == null) {
            return null;
        }
        DBServer ret = new DBServer(server.getId(), server.getName(), server.getNodeId(), server.getConfigId(), DBMonServiceUtil.controllerToDBMon(server.getRole()), DBMonServiceUtil.controllerToDBMon(server.getType()), server.getCreatedOn(), server.getModifiedOn(), server.getHost(), server.getPort(), server.getIpAddress(), server.getCpuCores(), server.getUniqueHostId(), DBMonServiceUtil.controllerToDBMon(server.getMetadataProps()));
        long[] backendIds = server.getBackendIds();
        if (backendIds != null) {
            HashSet<Long> backendIdSet = new HashSet<Long>();
            for (long backendId : backendIds) {
                backendIdSet.add(backendId);
            }
            ret.setBackendIds(backendIdSet);
        }
        ret.setSimMachineId(server.getSimMachineId());
        return ret;
    }

    public static com.appdynamics.dbmon.api.dtos.DBServerRole controllerToDBMon(DBServerRole role) {
        if (role == null) {
            return null;
        }
        return com.appdynamics.dbmon.api.dtos.DBServerRole.valueOf(role.toString());
    }

    public static DBServerSatelliteEntityType controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.DBServerSatelliteEntityType entityType) {
        if (entityType == null) {
            return null;
        }
        return DBServerSatelliteEntityType.valueOf(entityType.name());
    }

    public static List<DBServerSatelliteV2> controllerToDBMon(DBServerSatellite[] serverSatellites) {
        if (serverSatellites == null) {
            return Collections.emptyList();
        }
        ArrayList<DBServerSatelliteV2> returnList = new ArrayList<DBServerSatelliteV2>(serverSatellites.length);
        for (DBServerSatellite serverSatellite : serverSatellites) {
            returnList.add(DBMonServiceUtil.controllerToDBMon(serverSatellite));
        }
        return returnList;
    }

    public static DBServerSatelliteV2 controllerToDBMon(DBServerSatellite serverSatellite) {
        if (serverSatellite == null) {
            return null;
        }
        return new DBServerSatelliteV2(serverSatellite.getId(), serverSatellite.getName(), DBMonServiceUtil.controllerToDBMon(serverSatellite.getEntityType()), serverSatellite.getDbServerId());
    }

    public static List<DBServerSatelliteV2> serverSatelliteToDBServerSatelliteV2s(com.appdynamics.dbmon.api.dtos.DBServerSatellite[] serverSatellites) {
        if (serverSatellites == null) {
            return Collections.emptyList();
        }
        ArrayList<DBServerSatelliteV2> returnList = new ArrayList<DBServerSatelliteV2>(serverSatellites.length);
        for (com.appdynamics.dbmon.api.dtos.DBServerSatellite serverSatellite : serverSatellites) {
            returnList.add(DBMonServiceUtil.serverSatelliteToDBServerSatelliteV2(serverSatellite));
        }
        return returnList;
    }

    public static DBServerSatelliteV2 serverSatelliteToDBServerSatelliteV2(com.appdynamics.dbmon.api.dtos.DBServerSatellite serverSatellite) {
        if (serverSatellite == null) {
            return null;
        }
        DBServerSatelliteEntityType type = null;
        for (DBServerSatelliteEntityType entityType : DBServerSatelliteEntityType.values()) {
            if (!entityType.getEntityTypeName().equalsIgnoreCase(serverSatellite.getClass().getSimpleName())) continue;
            type = entityType;
        }
        return new DBServerSatelliteV2(serverSatellite.getId(), serverSatellite.getName(), type, serverSatellite.getDbServerId());
    }

    public static List<DBServerSatelliteV2> persistentObjectsToDBServerSatelliteV2s(APersistentObject[] persistentObjects) {
        if (persistentObjects == null) {
            return Collections.emptyList();
        }
        ArrayList<DBServerSatelliteV2> returnList = new ArrayList<DBServerSatelliteV2>(persistentObjects.length);
        for (APersistentObject persistentObject : persistentObjects) {
            returnList.add(DBMonServiceUtil.persistentObjectToDBServerSatelliteV2(persistentObject));
        }
        return returnList;
    }

    public static DBServerSatelliteV2 persistentObjectToDBServerSatelliteV2(APersistentObject persistentObject) {
        String className;
        if (persistentObject == null) {
            return null;
        }
        switch (className = persistentObject.getClass().getSimpleName()) {
            case "DBSchema": {
                DBSchema schema = (DBSchema)persistentObject;
                DBServerSatelliteEntityType entityType = DBServerSatelliteEntityType.DB_SCHEMA;
                return new DBServerSatelliteV2(schema.getId(), schema.getName(), entityType, schema.getDbServerId());
            }
            case "DBAppName": {
                DBAppName appName = (DBAppName)persistentObject;
                DBServerSatelliteEntityType entityType = DBServerSatelliteEntityType.DB_APP_NAME;
                return new DBServerSatelliteV2(appName.getId(), appName.getName(), entityType, appName.getDbServerId());
            }
            case "DBClient": {
                DBClient client = (DBClient)persistentObject;
                DBServerSatelliteEntityType entityType = DBServerSatelliteEntityType.DB_CLIENT;
                return new DBServerSatelliteV2(client.getId(), client.getName(), entityType, client.getDbServerId());
            }
            case "DBModule": {
                DBModule module = (DBModule)persistentObject;
                DBServerSatelliteEntityType entityType = DBServerSatelliteEntityType.DB_MODULE;
                return new DBServerSatelliteV2(module.getId(), module.getName(), entityType, module.getDbServerId());
            }
            case "DBNamespace": {
                DBNamespace namespace = (DBNamespace)persistentObject;
                DBServerSatelliteEntityType entityType = DBServerSatelliteEntityType.DB_NAMESPACE;
                return new DBServerSatelliteV2(namespace.getId(), namespace.getName(), entityType, namespace.getDbServerId());
            }
            case "DBProgram": {
                DBProgram program = (DBProgram)persistentObject;
                DBServerSatelliteEntityType entityType = DBServerSatelliteEntityType.DB_PROGRAM;
                return new DBServerSatelliteV2(program.getId(), program.getName(), entityType, program.getDbServerId());
            }
            case "DBSession": {
                DBSession session = (DBSession)persistentObject;
                DBServerSatelliteEntityType entityType = DBServerSatelliteEntityType.DB_SESSION;
                return new DBServerSatelliteV2(session.getId(), session.getName(), entityType, session.getDbServerId());
            }
        }
        throw new IllegalArgumentException("Unexpected entity type :" + className);
    }

    public static DBServerType dbMonToController(com.appdynamics.dbmon.api.dtos.DBServerType dbType) {
        if (dbType == null) {
            return null;
        }
        return DBServerType.valueOf((String)dbType.name());
    }

    public static DBServerRole dbMonToController(com.appdynamics.dbmon.api.dtos.DBServerRole role) {
        if (role == null) {
            return null;
        }
        return DBServerRole.valueOf((String)role.name());
    }

    public static DBCustomEventType dbMonToController(com.appdynamics.dbmon.api.dtos.DBCustomEventType type) {
        if (type == null) {
            return null;
        }
        return DBCustomEventType.valueOf((String)type.name());
    }

    public static DBCustomEventCriteriaType dbMonToController(com.appdynamics.dbmon.api.dtos.DBCustomEventCriteriaType type) {
        if (type == null) {
            return null;
        }
        return DBCustomEventCriteriaType.valueOf((String)type.name());
    }

    public static com.singularity.ee.controller.api.dto.dbmon.DBServer dbMonToController(DBServer server) {
        if (server == null) {
            return null;
        }
        com.singularity.ee.controller.api.dto.dbmon.DBServer ret = new com.singularity.ee.controller.api.dto.dbmon.DBServer(server.getId(), server.getName(), server.getInternalName(), server.getNodeId(), server.getConfigId(), DBMonServiceUtil.dbMonToController(server.getRole()), DBMonServiceUtil.dbMonToController(server.getType()), server.getCreatedOn(), server.getModifiedOn(), server.getHost(), server.getPort(), server.getIpAddress(), server.getCpuCores(), server.getUniqueHostId(), DBMonServiceUtil.dbMonToController(server.getMetadataProps()));
        Collection<Long> backendIds = server.getBackendIds();
        if (backendIds != null) {
            ret.setBackendIds(Longs.toArray(server.getBackendIds()));
        }
        ret.setSimMachineId(server.getSimMachineId());
        return ret;
    }

    public static QueryPlan dbMonToController(com.appdynamics.dbmon.api.dtos.QueryPlan queryPlan) {
        if (queryPlan == null) {
            return null;
        }
        return new QueryPlan(queryPlan.getId(), queryPlan.getQueryPlanHash(), queryPlan.getDbServerId(), queryPlan.getQueryPlanText());
    }

    public static com.appdynamics.dbmon.api.dtos.DBHostOS controllerToDBMon(DBHostOS hostOS) {
        return com.appdynamics.dbmon.api.dtos.DBHostOS.valueOf(hostOS.name());
    }

    public static DBHostOS dbMonToController(com.appdynamics.dbmon.api.dtos.DBHostOS hostOS) {
        return DBHostOS.valueOf((String)hostOS.name());
    }

    public static DBMonitorConfig controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig config) {
        if (config == null) {
            return null;
        }
        return new DBMonitorConfig(config.getId(), config.getName(), DBMonServiceUtil.controllerToDBMon(config.getType()), config.getHostname(), config.isUseWindowsAuth(), config.getUsername(), config.getPassword(), config.getPort(), config.isLoggingEnabled(), config.getExcludedSchemas(), config.isEnabled(), config.getDatabaseName(), config.getFailoverPartner(), config.isConnectAsSysdba(), config.isUseServiceName(), config.getSid(), config.getCustomConnectionString(), config.isEnterpriseDB(), config.isUseSSL(), config.isEnableOSMonitor(), config.getHostOS() == null ? null : DBMonServiceUtil.controllerToDBMon(config.getHostOS()), config.isUseLocalWMI(), config.getHostDomain(), config.getHostUsername(), config.getHostPassword(), config.isCertificateAuth(), config.isRemoveLiterals(), config.getSshPort(), config.getAgentName(), config.getDbInstanceIdentifier(), config.getRegion(), config.getCreatedOn(), config.getModifiedOn(), config.isDbCyberArkEnabled(), config.getDbCyberArkApplication(), config.getDbCyberArkSafe(), config.getDbCyberArkFolder(), config.getDbCyberArkObject(), config.isHwCyberArkEnabled(), config.getHwCyberArkApplication(), config.getHwCyberArkSafe(), config.getHwCyberArkFolder(), config.getHwCyberArkObject(), config.isOrapkiSslEnabled(), config.isOrasslClientAuthEnabled(), config.getOrasslTruststoreLoc(), config.getOrasslTruststoreType(), config.getOrasslTruststorePassword(), config.getOrasslKeystoreLoc(), config.getOrasslKeystoreType(), config.getOrasslKeystorePassword(), config.isLdapEnabled(), DBMonServiceUtil.controllerToDBMon(config.getSubConfigs()), DBMonServiceUtil.controllerToDBMon(config.getJdbcConnectionProperties()), config.getJmxPort(), config.getBackendIds(), DBMonServiceUtil.controllerToDBMon(config.getExtraProperties()), DBMonServiceUtil.controllerToDBMon(config.getDbMonConfProperties()));
    }

    private static CustomJdbcConnectionProperty[] controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty[] customJdbcConnectionProperties) {
        if (customJdbcConnectionProperties == null) {
            return new CustomJdbcConnectionProperty[0];
        }
        CustomJdbcConnectionProperty[] connectionProperties = new CustomJdbcConnectionProperty[customJdbcConnectionProperties.length];
        for (int i = 0; i < customJdbcConnectionProperties.length; ++i) {
            connectionProperties[i] = DBMonServiceUtil.controllerToDBMon(customJdbcConnectionProperties[i]);
        }
        return connectionProperties;
    }

    private static CustomJdbcConnectionProperty controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty customJdbcConnectionProperty) {
        if (customJdbcConnectionProperty == null) {
            return null;
        }
        return new CustomJdbcConnectionProperty(customJdbcConnectionProperty.getKey(), customJdbcConnectionProperty.getValue(), customJdbcConnectionProperty.isRedact());
    }

    private static com.appdynamics.dbmon.api.dtos.ExtraProperty[] controllerToDBMon(ExtraProperty[] extraProperties) {
        if (extraProperties == null) {
            return new com.appdynamics.dbmon.api.dtos.ExtraProperty[0];
        }
        com.appdynamics.dbmon.api.dtos.ExtraProperty[] extraPropertyArray = new com.appdynamics.dbmon.api.dtos.ExtraProperty[extraProperties.length];
        for (int i = 0; i < extraProperties.length; ++i) {
            extraPropertyArray[i] = DBMonServiceUtil.controllerToDBMon(extraProperties[i]);
        }
        return extraPropertyArray;
    }

    private static com.appdynamics.dbmon.api.dtos.ExtraProperty controllerToDBMon(ExtraProperty extraProperty) {
        if (extraProperty == null) {
            return null;
        }
        return new com.appdynamics.dbmon.api.dtos.ExtraProperty(extraProperty.getKey(), extraProperty.getValue(), extraProperty.isSensitive());
    }

    public static DBMonitorConfig[] controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig[] configs) {
        if (configs == null) {
            return null;
        }
        DBMonitorConfig[] configArray = new DBMonitorConfig[configs.length];
        for (int i = 0; i < configs.length; ++i) {
            configArray[i] = DBMonServiceUtil.controllerToDBMon(configs[i]);
        }
        return configArray;
    }

    public static com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig dbMonToControllerWithPasswordRedacted(DBMonitorConfig config) {
        if (config == null) {
            return null;
        }
        com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig dbMonitorConfig = DBMonServiceUtil.dbMonToController(config);
        DBMonServiceUtil.redactPasswordsInDBMonConfig(dbMonitorConfig);
        return dbMonitorConfig;
    }

    public static com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig dbMonToController(DBMonitorConfig config) {
        if (config == null) {
            return null;
        }
        return new com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig(config.getId(), config.getName(), DBMonServiceUtil.dbMonToController(config.getType()), config.getHostname(), config.isUseWindowsAuth(), config.getUsername(), config.getPassword(), config.getPort(), config.isLoggingEnabled(), config.getExcludedSchemas(), config.isEnabled(), config.getDatabaseName(), config.getFailoverPartner(), config.isConnectAsSysdba(), config.isUseServiceName(), config.getSid(), config.getCustomConnectionString(), config.isEnterpriseDB(), config.isUseSSL(), config.isEnableOSMonitor(), config.getHostOS() == null ? null : DBMonServiceUtil.dbMonToController(config.getHostOS()), config.isUseLocalWMI(), config.getHostDomain(), config.getHostUsername(), config.getHostPassword(), config.isCertificateAuth(), config.isRemoveLiterals(), config.getSshPort(), config.getAgentName(), config.getDbInstanceIdentifier(), config.getRegion(), config.getCreatedOn(), config.getModifiedOn(), config.isDbCyberArkEnabled(), config.getDbCyberArkApplication(), config.getDbCyberArkSafe(), config.getDbCyberArkFolder(), config.getDbCyberArkObject(), config.isHwCyberArkEnabled(), config.getHwCyberArkApplication(), config.getHwCyberArkSafe(), config.getHwCyberArkFolder(), config.getHwCyberArkObject(), config.isOrapkiSslEnabled(), config.isOrasslClientAuthEnabled(), config.getOrasslTruststoreLoc(), config.getOrasslTruststoreType(), config.getOrasslTruststorePassword(), config.getOrasslKeystoreLoc(), config.getOrasslKeystoreType(), config.getOrasslKeystorePassword(), config.isLdapEnabled(), DBMonServiceUtil.dbMonToController(config.getSubConfigs()), DBMonServiceUtil.dbMonToController(config.getJdbcConnectionProperties()), config.getJmxPort(), config.getBackendIds(), DBMonServiceUtil.dbMonToController(config.getExtraProperties()), DBMonServiceUtil.dbMonToController(config.getDbMonConfProperties()));
    }

    private static com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty[] dbMonToController(CustomJdbcConnectionProperty[] customJdbcConnectionProperties) {
        if (customJdbcConnectionProperties == null) {
            return new com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty[0];
        }
        com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty[] connectionProperties = new com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty[customJdbcConnectionProperties.length];
        for (int i = 0; i < customJdbcConnectionProperties.length; ++i) {
            connectionProperties[i] = DBMonServiceUtil.dbMonToController(customJdbcConnectionProperties[i]);
        }
        return connectionProperties;
    }

    private static com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty dbMonToController(CustomJdbcConnectionProperty customJdbcConnectionProperty) {
        if (customJdbcConnectionProperty == null) {
            return null;
        }
        return new com.singularity.ee.controller.api.dto.dbmon.CustomJdbcConnectionProperty(customJdbcConnectionProperty.getKey(), customJdbcConnectionProperty.getValue(), customJdbcConnectionProperty.isRedact());
    }

    public static ExtraProperty[] dbMonToController(com.appdynamics.dbmon.api.dtos.ExtraProperty[] extraProperties) {
        if (extraProperties == null) {
            return new ExtraProperty[0];
        }
        ExtraProperty[] extraPropertyArray = new ExtraProperty[extraProperties.length];
        for (int i = 0; i < extraProperties.length; ++i) {
            extraPropertyArray[i] = DBMonServiceUtil.dbMonToController(extraProperties[i]);
        }
        return extraPropertyArray;
    }

    private static ExtraProperty dbMonToController(com.appdynamics.dbmon.api.dtos.ExtraProperty extraProperty) {
        if (extraProperty == null) {
            return null;
        }
        return new ExtraProperty(extraProperty.getKey(), extraProperty.getValue(), extraProperty.isSensitive());
    }

    public static com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig[] dbMonToController(List<DBMonitorConfig> dbMonConfigs) {
        if (dbMonConfigs == null) {
            return null;
        }
        com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig[] configs = new com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig[dbMonConfigs.size()];
        int c = 0;
        for (DBMonitorConfig dbMonConfig : dbMonConfigs) {
            configs[c] = DBMonServiceUtil.dbMonToController(dbMonConfig);
            ++c;
        }
        return configs;
    }

    public static com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig[] dbMonToController(DBMonitorConfig[] configs) {
        if (configs == null) {
            return null;
        }
        com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig[] ret = new com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig[configs.length];
        int i = 0;
        for (DBMonitorConfig dbMonConfig : configs) {
            ret[i] = DBMonServiceUtil.dbMonToController(dbMonConfig);
            ++i;
        }
        return ret;
    }

    private static MetaDataProperty[] dbMonToController(com.appdynamics.dbmon.api.dtos.MetaDataProperty[] metaDataProperties) {
        if (metaDataProperties == null) {
            return new MetaDataProperty[0];
        }
        MetaDataProperty[] metaDataPropertyArray = new MetaDataProperty[metaDataProperties.length];
        for (int i = 0; i < metaDataProperties.length; ++i) {
            metaDataPropertyArray[i] = DBMonServiceUtil.dbMonToController(metaDataProperties[i]);
        }
        return metaDataPropertyArray;
    }

    private static MetaDataProperty dbMonToController(com.appdynamics.dbmon.api.dtos.MetaDataProperty metaDataProperty) {
        if (metaDataProperty == null) {
            return null;
        }
        return new MetaDataProperty(metaDataProperty.getKey(), metaDataProperty.getValue());
    }

    private static com.appdynamics.dbmon.api.dtos.MetaDataProperty[] controllerToDBMon(MetaDataProperty[] metaDataProperties) {
        if (metaDataProperties == null) {
            return new com.appdynamics.dbmon.api.dtos.MetaDataProperty[0];
        }
        com.appdynamics.dbmon.api.dtos.MetaDataProperty[] metaDataPropertiesArray = new com.appdynamics.dbmon.api.dtos.MetaDataProperty[metaDataProperties.length];
        for (int i = 0; i < metaDataProperties.length; ++i) {
            metaDataPropertiesArray[i] = DBMonServiceUtil.controllerToDBMon(metaDataProperties[i]);
        }
        return metaDataPropertiesArray;
    }

    private static com.appdynamics.dbmon.api.dtos.MetaDataProperty controllerToDBMon(MetaDataProperty metaDataProperty) {
        if (metaDataProperty == null) {
            return null;
        }
        return new com.appdynamics.dbmon.api.dtos.MetaDataProperty(metaDataProperty.getKey(), metaDataProperty.getValue());
    }

    public static com.singularity.ee.controller.api.dto.dbmon.DBServer[] dbMonToController(Collection<DBServer> dbMonServers) {
        if (dbMonServers == null) {
            return new com.singularity.ee.controller.api.dto.dbmon.DBServer[0];
        }
        com.singularity.ee.controller.api.dto.dbmon.DBServer[] collectorServers = new com.singularity.ee.controller.api.dto.dbmon.DBServer[dbMonServers.size()];
        int i = 0;
        for (DBServer dbMonServer : dbMonServers) {
            collectorServers[i++] = DBMonServiceUtil.dbMonToController(dbMonServer);
        }
        return collectorServers;
    }

    public static BlockStateMeasurement controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.BlockStateMeasurement measurement) {
        BlockStateMeasurement dbMonMeasurement = new BlockStateMeasurement();
        dbMonMeasurement.setServerId(measurement.getServerId());
        dbMonMeasurement.setQueryId(measurement.getQueryId());
        dbMonMeasurement.setBlockerQueryId(measurement.getBlockerQueryId());
        dbMonMeasurement.setTimestamp(measurement.getTimestamp());
        dbMonMeasurement.setBlockedSessionId(measurement.getBlockedSessionId());
        dbMonMeasurement.setBlockerSessionId(measurement.getBlockerSessionId());
        dbMonMeasurement.setBlockedClientId(measurement.getBlockedClientId());
        dbMonMeasurement.setBlockerUserId(measurement.getBlockerUserId());
        dbMonMeasurement.setBlockedUserId(measurement.getBlockedUserId());
        dbMonMeasurement.setBlockerClientId(measurement.getBlockerClientId());
        dbMonMeasurement.setlockObjectName(measurement.getLockObjectName());
        dbMonMeasurement.setBlockDurationMillis(measurement.getBlockDurationMillis());
        return dbMonMeasurement;
    }

    public static Collection<BlockStateMeasurement> controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.BlockStateMeasurement[] measurements) {
        ArrayList<BlockStateMeasurement> dbMonMeasurements = new ArrayList<BlockStateMeasurement>(measurements.length);
        for (com.singularity.ee.controller.api.dto.dbmon.BlockStateMeasurement measurement : measurements) {
            dbMonMeasurements.add(DBMonServiceUtil.controllerToDBMon(measurement));
        }
        return dbMonMeasurements;
    }

    private static QueryStatMeasurement controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.QueryStatMeasurement measurement) {
        QueryStatMeasurement dbMonMeasurement = new QueryStatMeasurement();
        dbMonMeasurement.setQueryId(measurement.getQueryId());
        dbMonMeasurement.setTimestamp(measurement.getTimestamp());
        dbMonMeasurement.setGroupId(measurement.getGroupId());
        dbMonMeasurement.setServerId(measurement.getServerId());
        dbMonMeasurement.setValues(measurement.getValues());
        dbMonMeasurement.setPlanHandles(measurement.getPlanHandles());
        return dbMonMeasurement;
    }

    public static Collection<QueryStatMeasurement> controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.QueryStatMeasurement[] measurements) {
        ArrayList<QueryStatMeasurement> dbMonMeasurements = new ArrayList<QueryStatMeasurement>(measurements.length);
        for (com.singularity.ee.controller.api.dto.dbmon.QueryStatMeasurement measurement : measurements) {
            dbMonMeasurements.add(DBMonServiceUtil.controllerToDBMon(measurement));
        }
        return dbMonMeasurements;
    }

    private static com.appdynamics.dbmon.api.dtos.WaitTimeMeasurement controllerToDBMon(WaitTimeMeasurement measurement) {
        com.appdynamics.dbmon.api.dtos.WaitTimeMeasurement dbMonMeasurement = new com.appdynamics.dbmon.api.dtos.WaitTimeMeasurement();
        dbMonMeasurement.setQueryId(measurement.getQueryId());
        dbMonMeasurement.setGroupId(measurement.getGroupId());
        dbMonMeasurement.setClientId(measurement.getClientId());
        dbMonMeasurement.setModuleId(measurement.getModuleId());
        dbMonMeasurement.setNamespaceId(measurement.getNamespaceId());
        dbMonMeasurement.setProgramId(measurement.getProgramId());
        dbMonMeasurement.setAppNameId(measurement.getAppNameId());
        dbMonMeasurement.setSchemaId(measurement.getSchemaId());
        dbMonMeasurement.setServerId(measurement.getServerId());
        dbMonMeasurement.setSessionId(measurement.getSessionId());
        dbMonMeasurement.setSnapshotGuid(measurement.getSnapshotGuid());
        dbMonMeasurement.setStatementEndOffset(measurement.getStatementEndOffset());
        dbMonMeasurement.setStatementStartOffset(measurement.getStatementStartOffset());
        dbMonMeasurement.setDbUserId(measurement.getDbUserId());
        dbMonMeasurement.setDbContainerId(measurement.getDbContainerId());
        dbMonMeasurement.setDbProcedureId(measurement.getDbProcedureId());
        dbMonMeasurement.setTimestamp(measurement.getTimestamp());
        dbMonMeasurement.setWaitDurationMillis(measurement.getWaitDurationMillis());
        dbMonMeasurement.setWaitStateId(measurement.getWaitStateId());
        dbMonMeasurement.setCommandType(measurement.getCommandType());
        return dbMonMeasurement;
    }

    public static Collection<com.appdynamics.dbmon.api.dtos.WaitTimeMeasurement> controllerToDBMon(WaitTimeMeasurement[] measurements) {
        ArrayList<com.appdynamics.dbmon.api.dtos.WaitTimeMeasurement> dbMonMeasurements = new ArrayList<com.appdynamics.dbmon.api.dtos.WaitTimeMeasurement>(measurements.length);
        for (WaitTimeMeasurement measurement : measurements) {
            dbMonMeasurements.add(DBMonServiceUtil.controllerToDBMon(measurement));
        }
        return dbMonMeasurements;
    }

    private static BucketStatMeasurement controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.BucketStatMeasurement measurement) {
        BucketStatMeasurement dbMonMeasurement = new BucketStatMeasurement();
        dbMonMeasurement.setBucketId(measurement.getBucketId());
        dbMonMeasurement.setTimestamp(measurement.getTimestamp());
        dbMonMeasurement.setServerId(measurement.getServerId());
        for (Map.Entry entry : measurement.getValues().entrySet()) {
            BucketStatType bucketStat = BucketStatType.valueOf((Integer)entry.getKey());
            if (bucketStat == null) continue;
            dbMonMeasurement.addValue(bucketStat, (Number)entry.getValue());
        }
        return dbMonMeasurement;
    }

    public static Collection<BucketStatMeasurement> controllerToDBMon(com.singularity.ee.controller.api.dto.dbmon.BucketStatMeasurement[] measurements) {
        ArrayList<BucketStatMeasurement> dbMonMeasurements = new ArrayList<BucketStatMeasurement>(measurements.length);
        for (com.singularity.ee.controller.api.dto.dbmon.BucketStatMeasurement measurement : measurements) {
            dbMonMeasurements.add(DBMonServiceUtil.controllerToDBMon(measurement));
        }
        return dbMonMeasurements;
    }

    private static void redactPasswordsInDBMonConfig(com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfig config) {
        if (config != null) {
            if (!DBMonServiceUtil.isEmpty(config.getPassword())) {
                config.setPassword(REDACTED_SECERET_DISPLAY_STRING);
            }
            if (!DBMonServiceUtil.isEmpty(config.getHostPassword())) {
                config.setHostPassword(REDACTED_SECERET_DISPLAY_STRING);
            }
            if (!DBMonServiceUtil.isEmpty(config.getOrasslTruststorePassword())) {
                config.setOrasslTruststorePassword(REDACTED_SECERET_DISPLAY_STRING);
            }
            if (!DBMonServiceUtil.isEmpty(config.getOrasslKeystorePassword())) {
                config.setOrasslKeystorePassword(REDACTED_SECERET_DISPLAY_STRING);
            }
            if (Objects.nonNull(config.getDbMonConfProperties())) {
                config.getDbMonConfProperties().forEach((name, prop) -> {
                    if (DBMonitorConstants.DBMON_CONFIG_PROPERTIES_SENSITIVE_ATTRIBUTES.contains(name)) {
                        prop.setValue(REDACTED_SECERET_DISPLAY_STRING);
                    }
                });
            }
        }
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    private static Map<String, DBMonitorConfigProperty> controllerToDBMon(Map<String, com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfigProperty> propertyMap) {
        if (propertyMap == null || propertyMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, DBMonitorConfigProperty> dbmonConfigProperties = new HashMap<String, DBMonitorConfigProperty>(propertyMap.size());
        propertyMap.forEach((key, prop) -> dbmonConfigProperties.put((String)key, new DBMonitorConfigProperty(prop.getId(), prop.getName(), prop.getValue(), prop.getDbMonitorConfigId())));
        return dbmonConfigProperties;
    }

    private static Map<String, com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfigProperty> dbMonToController(Map<String, DBMonitorConfigProperty> configPropertyMap) {
        if (configPropertyMap == null || configPropertyMap.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfigProperty> monitorConfigPropertyMap = new HashMap<String, com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfigProperty>(configPropertyMap.size());
        configPropertyMap.forEach((key, prop) -> monitorConfigPropertyMap.put((String)key, new com.singularity.ee.controller.api.dto.dbmon.DBMonitorConfigProperty(prop.getId(), prop.getName(), prop.getValue(), prop.getDbMonitorConfigId())));
        return monitorConfigPropertyMap;
    }
}

