/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.util;

import com.singularity.ee.controller.api.dto.MetricValue;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceStats;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceValue;
import java.util.Collection;

public class MetricUtils {
    public static void aggregatePerformanceStats(Collection<PerformanceStats> allPerfStats, PerformanceStats targetStats) {
        if (allPerfStats == null || allPerfStats.isEmpty() || targetStats == null) {
            return;
        }
        float totalCallsPerMin = 0.0f;
        float totalErrorPerMin = 0.0f;
        float averageResponseTime = 0.0f;
        for (PerformanceStats perfStats : allPerfStats) {
            float callsPerMin = perfStats.getCallsPerMinute().getValue();
            totalCallsPerMin += callsPerMin;
            totalErrorPerMin += perfStats.getErrorsPerMinute().getValue();
            averageResponseTime += perfStats.getAverageResponseTime().getValue() * callsPerMin;
        }
        averageResponseTime = (double)Math.abs(totalCallsPerMin - 0.0f) < 1.0E-4 ? 0.0f : averageResponseTime / totalCallsPerMin;
        PerformanceValue statsCallsPerMin = new PerformanceValue(0L, totalCallsPerMin);
        statsCallsPerMin.setMetricValue(new MetricValue((long)statsCallsPerMin.getValue()));
        PerformanceValue statsAverageResponseTime = new PerformanceValue(0L, averageResponseTime);
        statsAverageResponseTime.setMetricValue(new MetricValue((long)statsAverageResponseTime.getValue()));
        PerformanceValue statsErrorsPerMin = new PerformanceValue(0L, totalErrorPerMin);
        statsErrorsPerMin.setMetricValue(new MetricValue((long)statsErrorsPerMin.getValue()));
        targetStats.setCallsPerMinute(statsCallsPerMin);
        targetStats.setAverageResponseTime(statsAverageResponseTime);
        targetStats.setErrorsPerMinute(statsErrorsPerMin);
    }
}

