/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.util;

import com.singularity.ee.controller.api.constants.J2EEServerMetrics;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AppServerCategoryMappings
implements J2EEServerMetrics {
    public static final String TOMCAT_5_PREFIX = "Apache Tomcat/5";
    public static final String TOMCAT_6_PREFIX = "Apache Tomcat/6";
    public static final String WEBLOGIC_9_PREFIX = "WebLogic Server 9";
    public static final String WEBLOGIC_10_PREFIX = "WebLogic Server 10";
    public static final String JBOSS_4_PREFIX = "JBoss4";
    public static final String JBOSS_5_PREFIX = "JBoss5";
    public static final String GLASSFISH_V2_PREFIX = "Sun GlassFish Enterprise Server v2";
    public static final String WEBSPHERE_6_PREFIX = "Websphere6";
    public static final String WEBSPHERE_7_PREFIX = "Websphere7";
    public static final String IIS_6_PREFIX = "IIS 6";
    public static final String IIS_7_PREFIX = "IIS 7";
    private static Map<String, String> serverPrefixMappings;

    public static String getCategoryForPrefix(String prefix) {
        for (String serverVersionPrefix : serverPrefixMappings.keySet()) {
            if (!prefix.startsWith(serverVersionPrefix)) continue;
            return serverPrefixMappings.get(serverVersionPrefix);
        }
        return null;
    }

    static {
        HashMap<String, String> mappings = new HashMap<String, String>();
        mappings.put(TOMCAT_5_PREFIX, "Tomcat 5.x");
        mappings.put(TOMCAT_6_PREFIX, "Tomcat 6.x");
        mappings.put(WEBLOGIC_9_PREFIX, "Weblogic 9.x");
        mappings.put(WEBLOGIC_10_PREFIX, "Weblogic 10.x");
        mappings.put(JBOSS_4_PREFIX, "JBoss 4.x");
        mappings.put(JBOSS_5_PREFIX, "JBoss 5.x");
        mappings.put(GLASSFISH_V2_PREFIX, "Glassfish 2.x");
        mappings.put(WEBSPHERE_6_PREFIX, "Websphere 6.x");
        mappings.put(WEBSPHERE_7_PREFIX, "Websphere 7.x");
        mappings.put(IIS_6_PREFIX, IIS_6_PREFIX);
        mappings.put(IIS_7_PREFIX, IIS_7_PREFIX);
        serverPrefixMappings = Collections.unmodifiableMap(mappings);
    }
}

