/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.ui;

import com.singularity.ee.controller.api.constants.TimeRangeSpecifierType;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.util.clock.ClockUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public class TimeRangeUtil {
    private static Logger logger = Logger.getLogger(TimeRangeUtil.class.getName());
    public static final String TIME_RANGE_STRING_DELIMETER = ".";
    public static final String TIME_RANGE_STRING_DELIMETER_REGEX = "\\.";
    public static final String TIME_RANGE_PIPE_DELIMETER = "\\|";
    public static final String TIME_RANGE_PIPE = "|";
    public static final long MILLISECONDS_PER_MINUTE = 60000L;
    public static final long MILLISECONDS_PER_HOUR = 3600000L;
    public static final int DEFAULT_LOOKBACK_DAYS = 14;
    public static final int ARCHIVED_RETENTION_DAYS = 365;
    public static final TimeRangeSpecifierType[] RELATIVE_TIME_RANGES = new TimeRangeSpecifierType[]{TimeRangeSpecifierType.PREV_DAY_END, TimeRangeSpecifierType.PREV_WEEK_END, TimeRangeSpecifierType.PREV_MONTH_END};
    private static final int FOUR_HOURS_IN_MINUTES = 240;

    public static TimeRangeSpecifier createFromPreferenceString(String preferenceString) {
        return TimeRangeUtil.createFromPreferenceString(preferenceString, TIME_RANGE_STRING_DELIMETER_REGEX);
    }

    public static TimeRangeSpecifier createFromPreferenceString(String preferenceString, String delimiter) {
        int duration;
        long starttime;
        long endtime;
        String[] tokens;
        if (preferenceString == null) {
            return null;
        }
        if (delimiter == null) {
            delimiter = TIME_RANGE_STRING_DELIMETER_REGEX;
        }
        if ((tokens = preferenceString.split(delimiter)).length < 5) {
            return null;
        }
        String type = tokens[1];
        TimeRangeSpecifierType timeRangeSpecifierType = TimeRangeSpecifierType.valueOf((String)type);
        String timeZone = null;
        try {
            endtime = Long.valueOf(tokens[2]);
            starttime = Long.valueOf(tokens[3]);
            duration = Integer.valueOf(tokens[4]);
            if (TimeRangeUtil.hasTRSRelativeType(timeRangeSpecifierType)) {
                timeZone = tokens.length > 5 && tokens[5] != null && !tokens[5].isEmpty() ? TimeRangeUtil.parseTimeZoneOrGetDefault(tokens[5]) : ClockUtils.getDefaultServerTimeZone();
            }
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Unable to parse starttime, endtime or duration from: " + preferenceString);
        }
        TimeRangeSpecifier trs = new TimeRangeSpecifier();
        trs.setType(timeRangeSpecifierType);
        trs.setDurationInMinutes(duration);
        if (TimeRangeUtil.hasTRSRelativeType(timeRangeSpecifierType) && timeZone != null) {
            trs.setTimeZone(timeZone);
        }
        if (trs.getType() == TimeRangeSpecifierType.BETWEEN_TIMES) {
            trs.setEndTime(new Date(endtime));
            trs.setStartTime(new Date(starttime));
        }
        return trs;
    }

    public static boolean hasTRSRelativeType(TimeRangeSpecifierType timeRangeSpecifierType) {
        return Arrays.asList(RELATIVE_TIME_RANGES).contains(timeRangeSpecifierType);
    }

    public static String parseTimeZoneOrGetDefault(String timeZoneToken) {
        String timeZone;
        try {
            timeZone = TimeZone.getTimeZone(timeZoneToken).getID();
        }
        catch (Exception e) {
            logger.warning("Cannot find a valid TimeZone");
            timeZone = ClockUtils.getDefaultServerTimeZone();
        }
        return timeZone;
    }

    public static TimeRangeSpecifier getDefaultTimeRange() {
        return TimeRangeUtil.getBeforeNowTimeRangeSpecifier(15);
    }

    public static TimeRangeSpecifier getBeforeNowTimeRangeSpecifier(int minutesBeforeNow) {
        return com.appdynamics.controller.api.util.TimeRangeUtil.getBeforeNowTimeRangeSpecifier(minutesBeforeNow);
    }

    public static TimeRangeSpecifier createTimeRangeAroundTimestamp(long timestamp) {
        return TimeRangeUtil.createTimeRangeAroundTimestamp(timestamp, 3600000L);
    }

    public static TimeRangeSpecifier createTimeRangeAroundTimestamp(long timestamp, long delta) {
        TimeRangeSpecifier timeRangeSpecifier = new TimeRangeSpecifier();
        timeRangeSpecifier.setType(TimeRangeSpecifierType.BETWEEN_TIMES);
        timeRangeSpecifier.setStartTime(new Date(timestamp - delta));
        timeRangeSpecifier.setEndTime(new Date(timestamp + delta));
        return timeRangeSpecifier;
    }

    public static TimeRangeSpecifier convertToFixedTimeRange(TimeRangeSpecifier timeRangeSpecifier) {
        TimeRangeSpecifier newTimeRangeSpecifier = new TimeRangeSpecifier();
        newTimeRangeSpecifier.setType(TimeRangeSpecifierType.BETWEEN_TIMES);
        newTimeRangeSpecifier.setStartTime(timeRangeSpecifier.getTimeRange().getStartTime());
        newTimeRangeSpecifier.setEndTime(timeRangeSpecifier.getTimeRange().getEndTime());
        return newTimeRangeSpecifier;
    }

    public static TimeRangeSpecifier convertToFixedTimeRangeRoundedToInterval(TimeRangeSpecifier timeRangeSpecifier) {
        TimeRangeSpecifier newTimeRangeSpecifier = TimeRangeUtil.convertToFixedTimeRange(timeRangeSpecifier);
        long durationInMinutes = (newTimeRangeSpecifier.getEndTime().getTime() - newTimeRangeSpecifier.getStartTime().getTime()) / 60000L;
        int facetIntervalInMs = TimeRangeUtil.getResolutionFromTimeRangeDuration(durationInMinutes);
        newTimeRangeSpecifier.setStartTime(new Date(((long)facetIntervalInMs + newTimeRangeSpecifier.getStartTime().getTime()) / (long)facetIntervalInMs * (long)facetIntervalInMs));
        newTimeRangeSpecifier.setEndTime(new Date(((long)facetIntervalInMs + newTimeRangeSpecifier.getEndTime().getTime()) / (long)facetIntervalInMs * (long)facetIntervalInMs));
        return newTimeRangeSpecifier;
    }

    public static long calculateDurationInMinutes(TimeRangeSpecifier timeRangeSpecifier) {
        return com.appdynamics.controller.api.util.TimeRangeUtil.calculateDurationInMinutes(timeRangeSpecifier);
    }

    public static int getResolutionFromTimeRangeDuration(long timeRangeDurationInMs) {
        if (timeRangeDurationInMs > 1440L) {
            return 3600000;
        }
        if (timeRangeDurationInMs > 240L) {
            return 600000;
        }
        return 60000;
    }

    public static TimeRangeSpecifier extendTimeRangeIntoPast(TimeRangeSpecifier origTimeRange, int minutesToExtend) {
        return com.appdynamics.controller.api.util.TimeRangeUtil.extendTimeRangeIntoPast(origTimeRange, minutesToExtend);
    }

    public static TimeRangeSpecifier convertAndCheckTimeRangeSpecifier(String timeRangeSpecifierString) {
        TimeRangeSpecifier timeRangeSpecifier;
        try {
            timeRangeSpecifier = TimeRangeUtil.createFromPreferenceString(timeRangeSpecifierString);
            if (timeRangeSpecifier == null) {
                return null;
            }
            timeRangeSpecifier.readTimeRangeWithoutMutate();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            return null;
        }
        return timeRangeSpecifier;
    }

    public static TimeRangeSpecifier getTimeRangeFromUrlParam(String timeRangeUrlParam) {
        return TimeRangeUtil.getTimeRangeFromUrlParam(timeRangeUrlParam, TIME_RANGE_STRING_DELIMETER_REGEX);
    }

    public static TimeRangeSpecifier getTimeRangeFromUrlParam(String timeRangeUrlParam, String delimiter) {
        TimeRangeSpecifier timeRangeSpecifier = null;
        try {
            timeRangeSpecifier = TimeRangeUtil.createFromPreferenceString(timeRangeUrlParam, delimiter);
        }
        catch (Exception ex) {
            logger.warning("TimeRangeUtil.getTimeRangeFromUrlParam, unable to parse time range from query parameter: " + timeRangeUrlParam);
        }
        if (timeRangeSpecifier == null) {
            logger.warning("TimeRangeUtil.getTimeRangeFromUrlParam, not a valid time range: " + timeRangeUrlParam);
            throw new IllegalArgumentException("Not a valid time range: " + timeRangeUrlParam);
        }
        return timeRangeSpecifier;
    }

    public static TimeRangeSpecifier getFixedTimeRangeSpecifierForUnknownDelimiter(String timeRangeString) {
        String delimiter = timeRangeString.contains(TIME_RANGE_PIPE) ? TIME_RANGE_PIPE_DELIMETER : TIME_RANGE_STRING_DELIMETER_REGEX;
        return TimeRangeUtil.convertToFixedTimeRange(TimeRangeUtil.getTimeRangeFromUrlParam(timeRangeString, delimiter));
    }

    public static TimeRangeSpecifier get30MinsTimeRangeAroundTime(long timestamp) {
        TimeRangeSpecifier timeRangeSpecifier = new TimeRangeSpecifier();
        timeRangeSpecifier.setStartTime(new Date(timestamp - 900000L));
        timeRangeSpecifier.setEndTime(new Date(timestamp + 900000L));
        timeRangeSpecifier.setType(TimeRangeSpecifierType.BETWEEN_TIMES);
        return timeRangeSpecifier;
    }

    public static TimeRangeSpecifier getOneHourTimeRangeAroundTime(long timestamp) {
        TimeRangeSpecifier timeRangeSpecifier = new TimeRangeSpecifier();
        timeRangeSpecifier.setStartTime(new Date(timestamp - 1800000L));
        timeRangeSpecifier.setEndTime(new Date(timestamp + 1800000L));
        timeRangeSpecifier.setType(TimeRangeSpecifierType.BETWEEN_TIMES);
        timeRangeSpecifier.setDurationInMinutes((int)TimeUnit.HOURS.toMinutes(1L));
        return timeRangeSpecifier;
    }

    public static TimeRangeSpecifier getBeforeNowTimeRangeSpecifierWithDefaultLookbackDays() {
        TimeRangeSpecifier trs = new TimeRangeSpecifier();
        trs.setType(TimeRangeSpecifierType.BEFORE_NOW);
        trs.setDurationInMinutes((int)TimeUnit.DAYS.toMinutes(14L));
        return trs;
    }

    public static TimeRangeSpecifier getBeforeNowTimeRangeSpecifierWithArchivedLookbackDays() {
        TimeRangeSpecifier trs = new TimeRangeSpecifier();
        trs.setType(TimeRangeSpecifierType.BEFORE_NOW);
        trs.setDurationInMinutes((int)TimeUnit.DAYS.toMinutes(365L));
        return trs;
    }

    public static TimeRangeSpecifier getBetweenTimesTimeRangeSpecifierWithDefaultLookBackDays() {
        long endTime = System.currentTimeMillis();
        long startTime = endTime - TimeUnit.DAYS.toMillis(14L);
        return TimeRangeUtil.createBetweenTimesTimeRangeSpecifier(new Date(startTime), new Date(endTime));
    }

    public static TimeRangeSpecifier createBetweenTimesTimeRangeSpecifier(Date startTime, Date endTime) {
        TimeRangeSpecifier timeRangeSpecifier = new TimeRangeSpecifier();
        timeRangeSpecifier.setStartTime(startTime);
        timeRangeSpecifier.setEndTime(endTime);
        timeRangeSpecifier.setType(TimeRangeSpecifierType.BETWEEN_TIMES);
        timeRangeSpecifier.getTimeRange();
        return timeRangeSpecifier;
    }

    public static enum TimeRangeLabel {
        LAST_5_MINUTES("last_5_minutes", 5),
        LAST_15_MINUTES("last_15_minutes", 15),
        LAST_30_MINUTES("last_30_minutes", 30),
        LAST_1_HOUR("last_1_hour", 60),
        LAST_2_HOURS("last_2_hours", 120),
        LAST_3_HOURS("last_3_hours", 180),
        LAST_4_HOURS("last_4_hours", 240),
        LAST_6_HOURS("last_6_hours", 360),
        LAST_12_HOURS("last_12_hours", 720),
        LAST_1_DAY("last_1_day", 1440),
        LAST_3_DAYS("last_3_days", 4320),
        LAST_1_WEEK("last_1_week", 10080),
        LAST_2_WEEKS("last_2_weeks", 20160),
        LAST_1_MONTH("last_1_month", 43200),
        LAST_3_MONTHS("last_3_months", 129600),
        LAST_6_MONTHS("last_6_months", 259200),
        LAST_1_YEAR("last_1_year", 525600),
        CUSTOM_TIME_RANGE("Custom_Time_Range", -1);

        private String text;
        private int minutes;
        private static final Map<Integer, String> minutesToText;

        private TimeRangeLabel(String text, int minutes) {
            this.text = text;
            this.minutes = minutes;
        }

        public int getMinutes() {
            return this.minutes;
        }

        public String toString() {
            return this.text;
        }

        public static String getTextForMinutes(int minutes) {
            if (minutesToText.containsKey(minutes)) {
                return minutesToText.get(minutes);
            }
            return null;
        }

        private static Map<Integer, String> initializeMapping() {
            HashMap<Integer, String> map = new HashMap<Integer, String>();
            for (TimeRangeLabel label : TimeRangeLabel.values()) {
                map.put(label.minutes, label.text);
            }
            return map;
        }

        static {
            minutesToText = Collections.unmodifiableMap(TimeRangeLabel.initializeMapping());
        }
    }
}

