/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.services.model;

import com.singularity.ee.controller.api.dto.AgentInstallationFilter;
import com.singularity.ee.controller.api.dto.AgentVersionRequest;
import com.singularity.ee.controller.api.dto.FmTask;
import com.singularity.ee.controller.api.dto.HostInfo;
import com.singularity.ee.controller.api.dto.RollbackValidationInfo;
import com.singularity.ee.controller.api.dto.SmartAgentResponse;
import com.singularity.ee.controller.api.dto.Task;
import com.singularity.ee.controller.api.dto.UiTask;
import com.singularity.ee.controller.api.dto.UpgradeOrRestartValidationInfo;
import com.singularity.ee.controller.api.dto.UpgradeValidationInfo;
import com.singularity.ee.controller.api.dto.fleetmanagement.DeploymentStatus;
import com.singularity.ee.controller.api.dto.fleetmanagement.TaskStatusInfo;
import com.singularity.ee.controller.api.exceptions.IllegalObjectStateException;
import com.singularity.ee.controller.api.exceptions.ObjectAlreadyExistsException;
import com.singularity.ee.controller.api.exceptions.ObjectNotFoundException;
import com.singularity.ee.controller.api.exceptions.ServerException;
import com.singularity.ee.controller.api.exceptions.UnauthorizedAccessException;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

public interface ITaskDeploymentManager {
    public Task createTaskDeployment(Task var1, UriInfo var2, HttpHeaders var3) throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalObjectStateException, ServerException;

    public List<HostInfo> getAllUniqueHostsForAccount() throws ServerException;

    public List<HostInfo> getAllUniqueHostsForInstallation(String var1) throws ServerException;

    public List<String> getAvailableAgents(AgentVersionRequest var1);

    public List<String> getAvailableAgentsForRollback(AgentVersionRequest var1);

    public String getDeploymentConfig(long var1) throws UnauthorizedAccessException;

    public void updateDeploymentStatus(List<DeploymentStatus> var1) throws ServerException;

    public TaskStatusInfo getTaskStatus(long var1) throws UnauthorizedAccessException;

    public List<String> listSmartAgentsHostsInternal() throws IllegalObjectStateException;

    public List<SmartAgentResponse> listSmartAgents(int var1, int var2, AgentInstallationFilter var3) throws IllegalObjectStateException, UnauthorizedAccessException;

    public List<SmartAgentResponse> listSmartAgents(List<Integer> var1, AgentInstallationFilter var2) throws IllegalObjectStateException, UnauthorizedAccessException;

    public void deleteSmartAgentInternal(List<String> var1) throws ServerException;

    public List<UiTask> getTasks(String var1, int var2, int var3) throws ServerException;

    public List<FmTask> getOpenTasksForFMS(String var1, int var2, int var3, UriInfo var4, HttpHeaders var5) throws UnauthorizedAccessException;

    public int getTotalTaskCount(String var1) throws UnauthorizedAccessException;

    public File retrieveTaskLogs(long var1) throws IOException, UnauthorizedAccessException;

    public int getSmartAgentsCount(AgentInstallationFilter var1) throws UnauthorizedAccessException;

    public Map<Integer, SmartAgentResponse> getSmartAgentsMap(AgentInstallationFilter var1) throws UnauthorizedAccessException;

    public TreeSet<String> getSmartAgentVersions() throws UnauthorizedAccessException;

    public TreeSet<String> getSmartAgentMonitoredApplications() throws UnauthorizedAccessException;

    public TreeSet<String> fetchVersionListForAgents(String var1);

    public RollbackValidationInfo validateRollback(List<Long> var1) throws UnauthorizedAccessException;

    public UpgradeValidationInfo validateUpgrade(List<Long> var1) throws UnauthorizedAccessException;

    public UpgradeOrRestartValidationInfo validateUpgradeOrRestart(List<Long> var1) throws UnauthorizedAccessException;

    public Map<Long, Map<String, Object>> getRequiredInfoFromLastDeploymentForAgentInstallations(Set<Long> var1);

    public void refreshAgentVersionCache();

    public boolean isInternetReachable(String var1);

    public Boolean isPortalConnected(int var1);

    public String getLastRefreshTimestamp();

    public void updateSmartAgentStatus(List<String> var1) throws ServerException;
}

