/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.services.model;

import com.appdynamics.eumcloud.configuration.dto.EUMCloudMobileAgentConfig;
import com.appdynamics.eumcloud.configuration.dto.EUMCloudPageConfig;
import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.constants.InstrumentationLevel;
import com.singularity.ee.controller.api.dto.AgentInstallInfo;
import com.singularity.ee.controller.api.dto.AllApplications;
import com.singularity.ee.controller.api.dto.Application;
import com.singularity.ee.controller.api.dto.ApplicationConfiguration;
import com.singularity.ee.controller.api.dto.ApplicationType;
import com.singularity.ee.controller.api.dto.ApplicationTypeInfo;
import com.singularity.ee.controller.api.dto.ApplicationWithAgentManagementPerms;
import com.singularity.ee.controller.api.dto.CallGraphConfiguration;
import com.singularity.ee.controller.api.dto.EUMConfiguration;
import com.singularity.ee.controller.api.dto.EUMEnabledInfo;
import com.singularity.ee.controller.api.dto.ErrorConfiguration;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.controller.api.dto.pages.applications.AllApplicationsNameItem;
import com.singularity.ee.controller.api.dto.pages.shared.PaginatedResponstWithNextPage;
import com.singularity.ee.controller.api.exceptions.ServerException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriInfo;

public interface IApplicationManager {
    public Application createApplication(Application var1) throws ServerException;

    public void deleteApplicationBlocking(long var1) throws ServerException;

    public void deleteApplication(long var1) throws ServerException;

    public Application updateApplication(Application var1) throws ServerException;

    public Application updateApplication(Application var1, String var2) throws ServerException;

    public void setApplicationInstrumentationLevel(long var1, InstrumentationLevel var3) throws ServerException;

    public Application[] getAllVisibleApplications() throws ServerException;

    public Application[] getAllVisibleApplicationsForAnalyticsConfiguration() throws ServerException;

    public Application[] getAllApplicationsIncludingHidden() throws ServerException;

    public String[] getAllApplicationNames() throws ServerException;

    public Application getApplicationById(long var1) throws ServerException;

    public Application[] getApplicationsByIds(long[] var1) throws ServerException;

    public Application[] getActiveApplicationsByIds(long[] var1) throws ServerException;

    public Application getApplicationByName(String var1) throws ServerException;

    public Application[] getApplicationsByNames(Set<String> var1) throws ServerException;

    public ApplicationConfiguration getApplicationConfiguration(long var1) throws ServerException;

    public ApplicationConfiguration getApplicationConfiguration(long var1, String var3) throws ServerException;

    public boolean isEumMobileEnabledForApp(long var1) throws ServerException;

    public EUMEnabledInfo[] getEumEnabledInfoForAllApplicationsIncludingHidden() throws ServerException;

    public ApplicationTypeInfo getApplicationTypeInfo(Application var1) throws ServerException;

    public AllApplications getApplicationsAllTypes() throws ServerException;

    public AllApplications getLiveApplicationsAllTypes(TimeRangeSpecifier var1) throws ServerException;

    public Application[] getApplicationsByType(ApplicationType var1) throws ServerException;

    public Application[] getLiveApplicationsByType(ApplicationType var1, TimeRangeSpecifier var2) throws ServerException;

    public Application[] getApplicationsByTypes(ApplicationType ... var1) throws ServerException;

    @Deprecated
    public AgentInstallInfo[] getAgentsTryingToConnect();

    @Deprecated
    public AgentInstallInfo[] getConnectedAgentsInfo();

    public NameValuePair[][] getAgentsInfo(boolean var1);

    public int getConnectedAgentsLimit();

    public void releaseConnectedAgent(boolean var1);

    @Deprecated
    public void switchConnectedAgent(AgentInstallInfo var1, boolean var2);

    public void switchConnectedAgentID(String var1, boolean var2);

    public void recycle(boolean var1, boolean var2, boolean var3);

    public EUMConfiguration updateEUMConfiguration(long var1, EUMConfiguration var3) throws ServerException;

    public EUMConfiguration updateEUMConfiguration(long var1, EUMConfiguration var3, String var4) throws ServerException;

    public EUMConfiguration updateImportingEUMConfiguration(long var1, EUMConfiguration var3) throws ServerException;

    public NameValuePair[] getProperties(long var1) throws ServerException;

    public void setProperties(long var1, NameValuePair[] var3) throws ServerException;

    public String getProperty(long var1, String var3) throws ServerException;

    public String putProperty(long var1, String var3, String var4) throws ServerException;

    public String removeProperty(long var1, String var3) throws ServerException;

    public boolean isAsyncActivitySupported(long var1) throws ServerException;

    public void setAsyncActivitySupported(long var1, boolean var3) throws ServerException;

    public EUMCloudPageConfig getEumCloudPageConfig(long var1) throws ServerException;

    public Map<Long, EUMCloudPageConfig> getEumCloudPageConfigsForWebEnabledApps(long var1) throws ServerException;

    public EUMCloudPageConfig getEumCloudMobileConfig(long var1) throws ServerException;

    public EUMCloudPageConfig getEumCloudIotConfig(long var1) throws ServerException;

    public EUMCloudMobileAgentConfig getEumMobileAgentConfig(long var1) throws ServerException;

    public void setEumCloudPageConfig(long var1, EUMCloudPageConfig var3) throws ServerException;

    public void setEumCloudMobileConfig(long var1, EUMCloudPageConfig var3) throws ServerException;

    public void setEumCloudIotConfig(long var1, EUMCloudPageConfig var3) throws ServerException;

    public void setEumMobileAgentConfig(long var1, EUMCloudMobileAgentConfig var3) throws ServerException;

    public String getEUMDefaultBeaconHostName();

    public String getEUMDefaultBeaconHostNameHttps();

    public String getEUMDefaultJsAgentCdnHostHttp();

    public String getEUMDefaultJsAgentCdnHostHttps();

    public String getEUMAdrumExtensionDownloadLinkUrl();

    public String getEUMAdrumXDDownloadLinkUrl();

    public String getEUMInjectedHTML(String var1) throws ServerException;

    public String getEUMInjectedJS(String var1, String var2, String var3, String var4, String var5, String var6, String var7, boolean var8, boolean var9, String var10, String var11, String var12, int var13) throws ServerException;

    public boolean isEUM10DataPresent(long var1) throws ServerException;

    public boolean isMobileEumEnabled() throws ServerException;

    public long importUploadedApplication(String var1, String var2) throws ServerException;

    public Application getDBMonitoringApplication();

    public long getDBMonitoringApplicationIdForAccount(long var1) throws ServerException;

    public void setApplicationBTDiscoveryLocked(long var1, boolean var3) throws ServerException;

    public boolean isApplicationBTDiscoveryLocked(long var1) throws ServerException;

    public int getBtCleanupTimeframeInMinutes(long var1) throws ServerException;

    public void setBtCleanupTimeframeInMinutes(long var1, int var3) throws ServerException;

    public int getBtCleanupCallCountThreshold(long var1) throws ServerException;

    public void setBtCleanupCallCountThreshold(long var1, int var3) throws ServerException;

    public void setBtRetentionPeriodInHours(long var1, int var3) throws ServerException;

    public void setErrorConfiguration(long var1, ErrorConfiguration var3) throws ServerException;

    public void setCallGraphConfiguration(long var1, CallGraphConfiguration var3, AgentType var4) throws ServerException;

    public int getBtRetentionPeriodInHours(long var1) throws ServerException;

    public void setAllAgentsDisabled(long var1, boolean var3) throws ServerException;

    public boolean areAllAgentsDisabled(long var1) throws ServerException;

    public Long[] getApplicationsWithTiers() throws ServerException;

    public void enableMdsTransactionConfigForApp(long var1) throws ServerException;

    public boolean isMdsTransactionConfigEnabledForApp(long var1) throws ServerException;

    public void disableMdsTransactionConfigForApp(long var1) throws ServerException;

    public void enableMdsBackendConfigForApp(long var1) throws ServerException;

    public void disableMdsBackendConfigForApp(long var1) throws ServerException;

    public boolean isMdsBackendConfigEnabledForApp(long var1);

    public Application createApplicationDupsOk(Application var1) throws ServerException;

    public Application[] getStaleApplicationsForAccount() throws ServerException;

    public boolean isApplicationVisible(Application var1);

    public int[] getLiveTierNodeCount(long var1, TimeRangeSpecifier var3);

    public PaginatedResponstWithNextPage<AllApplicationsNameItem> fetchAppNameWithKeys(int var1, int var2, UriInfo var3) throws ServerException;

    public PaginatedResponstWithNextPage<Integer> getApplicationIdsByAccount(int var1, int var2, UriInfo var3) throws ServerException;

    public Long getOverageApplicationIdForCurrentAccount() throws ServerException;

    public List<ApplicationWithAgentManagementPerms> populateAgentManagementPermissions(Application[] var1) throws ServerException;

    public Long[] getAppIdsByTargetedEUMAppId(long var1);
}

