/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.services.model;

import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.dto.AAppDynamicsAgent;
import com.singularity.ee.controller.api.dto.AgentInstallation;
import com.singularity.ee.controller.api.dto.ApplicationComponent;
import com.singularity.ee.controller.api.dto.ApplicationComponentNode;
import com.singularity.ee.controller.api.dto.ApplicationComponentNodeContainerId;
import com.singularity.ee.controller.api.dto.ComponentType;
import com.singularity.ee.controller.api.dto.ContextualLoggingSession;
import com.singularity.ee.controller.api.dto.ContextualLoggingType;
import com.singularity.ee.controller.api.dto.K8sPod;
import com.singularity.ee.controller.api.dto.K8sWorkload;
import com.singularity.ee.controller.api.dto.NameValuePair;
import com.singularity.ee.controller.api.dto.NodeMetaInfo;
import com.singularity.ee.controller.api.dto.NodeResourceData;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.controller.api.dto.UnregisteredComponentNode;
import com.singularity.ee.controller.api.dto.UnresolvedBackendCallInfo;
import com.singularity.ee.controller.api.dto.pages.shared.PaginatedResponstWithNextPage;
import com.singularity.ee.controller.api.dto.pages.tiers.TierNameItem;
import com.singularity.ee.controller.api.dto.tag.TagInfo;
import com.singularity.ee.controller.api.exceptions.IllegalObjectStateException;
import com.singularity.ee.controller.api.exceptions.IllegalOperationException;
import com.singularity.ee.controller.api.exceptions.ObjectAlreadyExistsException;
import com.singularity.ee.controller.api.exceptions.ObjectNotFoundException;
import com.singularity.ee.controller.api.exceptions.ServerException;
import com.singularity.ee.controller.api.util.ApplicationMachine;
import com.singularity.ee.util.version.AgentVersion;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public interface IApplicationComponentManager {
    public ApplicationComponent createApplicationComponent(ApplicationComponent var1) throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalObjectStateException, ServerException;

    public ApplicationComponent createApplicationComponentWithPermissionCheck(ApplicationComponent var1) throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalObjectStateException, ServerException;

    public ApplicationComponentNode createApplicationComponentNode(ApplicationComponentNode var1) throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalObjectStateException, ServerException;

    public ApplicationComponent updateApplicationComponent(ApplicationComponent var1) throws ObjectNotFoundException, ObjectAlreadyExistsException, IllegalOperationException, ServerException;

    public ApplicationComponentNode updateApplicationComponentNode(ApplicationComponentNode var1) throws ObjectNotFoundException, ObjectAlreadyExistsException, ServerException;

    public void deleteApplicationComponent(long var1) throws ObjectNotFoundException, IllegalOperationException, ServerException;

    public void deleteApplicationComponents(long[] var1) throws ObjectNotFoundException, IllegalOperationException, ServerException;

    public void deleteApplicationComponentNodes(long[] var1) throws ObjectNotFoundException, ServerException;

    public void deleteApplicationComponentNode(long var1) throws ObjectNotFoundException, ServerException;

    public String[] getAllApplicationComponentNames(long var1) throws ServerException;

    public ApplicationComponent[] getAllApplicationComponents(long var1) throws ServerException;

    public List<ApplicationComponent> getAllApplicationComponentsFromCache(long var1) throws ServerException;

    public ApplicationComponent[] getAllApplicationComponentsWithNodeCounts(long var1) throws ServerException;

    public ApplicationComponent[] getAllLiveApplicationComponents(long var1, TimeRangeSpecifier var3) throws ServerException;

    public ApplicationComponent getApplicationComponentById(long var1) throws ServerException;

    public ApplicationComponent getApplicationComponentByIdWithTimeRange(long var1, TimeRangeSpecifier var3) throws ServerException;

    public ApplicationComponent getApplicationComponentByName(long var1, String var3) throws ServerException;

    public ApplicationComponent getApplicationComponentByNodeId(long var1) throws ServerException;

    public ApplicationComponentNode[] getApplicationComponentNodesByName(long var1, String var3) throws ServerException;

    public ApplicationComponentNode[] getApplicationComponentNodeSummariesByMachineId(long var1) throws ServerException;

    public ApplicationComponentNode getApplicationComponentNodeById(long var1) throws ServerException;

    public ApplicationComponentNode getApplicationComponentNodeByIdForExternalUser(long var1, boolean var3) throws ServerException;

    public String getApplicationComponentNodeNameById(long var1) throws ServerException;

    public AAppDynamicsAgent getAppAgentByComponentNodeId(long var1) throws ServerException;

    public UnregisteredComponentNode[] getUnRegisteredComponentNodes() throws ServerException;

    public UnresolvedBackendCallInfo[] getAllUnresolvedBackendCallInfos(long var1) throws ServerException;

    public UnresolvedBackendCallInfo[] getResolvedBackendCallInfosForApplicationComponent(long var1) throws ObjectNotFoundException, ServerException;

    public UnresolvedBackendCallInfo getUnresolvedBackendCallInfoById(long var1) throws ServerException;

    public UnresolvedBackendCallInfo[] getUnresolvedBackendCallInfosById(long ... var1) throws ServerException;

    public UnresolvedBackendCallInfo[] getUnresolvedBackendCallInfosByIdErrorsOK(long ... var1) throws ServerException;

    public void resolveBackendCallInfoToApplicationComponent(long var1, long var3) throws ServerException;

    public UnresolvedBackendCallInfo setUnresolvedBackendCallInfoDisplayName(long var1, String var3) throws ServerException;

    public UnresolvedBackendCallInfo markUnresolvedBackendCallInfoAsDb2OnzOS(long var1, boolean var3) throws ServerException;

    public UnresolvedBackendCallInfo setUnresolvedBackendCallInfoVisualization(long var1, NameValuePair[] var3) throws ServerException;

    public void requestAgentReregistration(long var1) throws ServerException;

    public void requestAgentsReregistration(long[] var1) throws ServerException;

    public void requestAgentReregistrationWithNewComponentAssignment(long var1, long var3) throws ServerException;

    public boolean isAgentReRegistrationRequested(long var1) throws ServerException;

    public void cancelAgentReregistrationRequest(long var1) throws ServerException;

    public ApplicationComponentNode[] getApplicationComponentNodesById(long ... var1) throws ServerException;

    public ApplicationComponentNode[] getApplicationComponentNodesByComponentId(long var1) throws ServerException;

    public ApplicationComponentNode[] getAllApplicationComponentNodesByComponentId(long var1) throws ServerException;

    public List<ApplicationComponentNode> getApplicationComponentNodesByComponentIdWithCache(long var1) throws ServerException;

    public ApplicationComponentNode[] getLiveApplicationComponentNodesByComponentId(long var1, TimeRangeSpecifier var3) throws ServerException;

    public ApplicationComponentNode[] getApplicationComponentNodesWithNoMetaDataByComponentId(long var1) throws ServerException;

    public ApplicationComponentNode[] getApplicationComponentNodesByApplicationId(long var1);

    public ApplicationComponentNode[] getApplicationComponentNodesWithHistoricalByApplicationId(long var1, boolean var3);

    public HashMap<Long, String> getAllSimMachines();

    public List<ApplicationComponentNode> getApplicationComponentNodesByMachineIdAndAppId(long var1, long var3);

    public List<ApplicationComponentNode> getApplicationComponentNodesByMachineNameAndAppId(String var1, long var2) throws ServerException;

    public ApplicationComponentNode[] getLiveApplicationComponentNodesWithNoMetaDataByApplicationId(long var1, TimeRangeSpecifier var3);

    public ApplicationComponent[] getApplicationComponentsById(long ... var1) throws ServerException;

    public String[] getApplicationComponentNodeMetaInfoKeys(long var1) throws ServerException;

    public ApplicationComponentNode[] getApplicationComponentNodesByNodeMetaInfo(long var1, NameValuePair var3) throws ServerException;

    public NodeMetaInfo[] getAllNodeMetaInfoForApplicationComponentNodes(long ... var1) throws ServerException;

    public boolean markApplicationComponentNodeHistorical(long var1, boolean var3) throws ServerException;

    public boolean markApplicationComponentNodeHistoricalTxnRequired(long var1, boolean var3) throws ServerException;

    public void startContextualLoggingSession(long var1, String[] var3, long var4) throws ServerException;

    public ContextualLoggingSession[] getContextualLoggingSessions(long var1) throws ServerException;

    public long getApplicationIdForNode(long var1);

    public ApplicationComponentNode getReusableNodeSummary(String var1, String var2, String var3, String var4, AgentType var5, String var6, AgentVersion var7, int var8) throws ServerException;

    public ApplicationComponentNode markNodeRecent(String var1, long var2, String var4, String var5, String var6, AgentType var7, String var8, AgentVersion var9, int var10) throws ServerException;

    public ApplicationComponentNode getReusableNodeSummary(String var1, long var2, String var4, String var5, String var6, AgentType var7, String var8, AgentVersion var9, int var10) throws ServerException;

    public ApplicationComponentNode updateMachineForApplicationComponentNode(long var1, String var3, String var4) throws ServerException;

    public ApplicationComponentNode registerApplicationComponentNode(String var1, String var2, String var3, String var4, AgentType var5, String var6, AgentVersion var7, String var8, int var9, boolean var10) throws ServerException;

    public ApplicationComponentNode registerApplicationComponentNode(String var1, String var2, String var3, String var4, AgentType var5, String var6, String var7, String var8, int var9, boolean var10, String var11, String var12, String var13, boolean var14, boolean var15) throws ServerException;

    public void updateApplicationComponentNodeAgentRuntimeStateOptimisticLockingRecovery(long var1, String[] var3, NameValuePair[] var4, NameValuePair[] var5, NameValuePair[] var6, String var7) throws ServerException;

    public void updateApplicationComponentNodeAgentRuntimeStateOptimisticLockingRecovery(long var1, String[] var3, NameValuePair[] var4, NameValuePair[] var5, NameValuePair[] var6, String var7, boolean var8) throws ServerException;

    public void updateApplicationComponentTypeWithCacheUpdate(long var1, ComponentType var3) throws ServerException;

    public long getApplicationIdByNodeId(long var1) throws ServerException;

    public ApplicationComponentNode updateApplicationComponentNodeOptimisticLockingRecovery(long var1, String var3, long var4, boolean var6, AgentType var7, String var8, boolean var9) throws ServerException;

    public ApplicationComponentNode setApplicationComponentNodeNameByReusingNodeNames(long var1, String var3) throws ServerException;

    public boolean deleteDummyApplicationComponentNodeForMachine(long var1, long var3) throws ServerException;

    public ApplicationComponent createApplicationComponentDupsOk(ApplicationComponent var1, boolean var2) throws ServerException;

    public ApplicationComponentNode createApplicationComponentNodeDupsOk(ApplicationComponentNode var1) throws ServerException;

    public ApplicationComponentNode createApplicationComponentNodeDupsOk(ApplicationComponentNode var1, boolean var2) throws ServerException;

    public AgentVersion getAppAgentVersion(long var1) throws ServerException;

    public boolean isContextualLoggingSessionActive(long var1, ContextualLoggingType var3);

    public ApplicationComponent[] getStaleTiersForAccount() throws ServerException;

    public ApplicationComponent[] getStaleTiersForApplication(long var1) throws ServerException;

    public UnresolvedBackendCallInfo[] getStaleBackendsForApplication(long var1) throws ServerException;

    public UnresolvedBackendCallInfo[] getStaleBackendsForAccount() throws ServerException;

    public NodeResourceData[] getStaleNodesForCurrentAccount() throws ServerException;

    public NodeResourceData[] getStaleNodesForApplication(long var1) throws ServerException;

    public boolean isApplicationComponentVisible(ApplicationComponent var1);

    public boolean isApplicationComponentNodeVisible(ApplicationComponentNode var1);

    public int getNumberOfLiveNodes(long var1, TimeRangeSpecifier var3);

    public ApplicationMachine getApplicationMachine(long var1, long var3) throws ServerException;

    public ApplicationComponentNode getAppComponentNodeWithFixedDBCollectorName(long var1) throws ServerException;

    public AgentInstallation updateAgentInstallation(long var1, String var3, String var4, String var5);

    public PaginatedResponstWithNextPage<TierNameItem> getComponentIdsWithName(PaginatedResponstWithNextPage<Integer> var1);

    public TreeSet<String> fetchVersionListForAgents(List<String> var1);

    public List<ApplicationComponentNodeContainerId> getApplicationComponentContainerIdsByAppId(Long var1);

    public List<ApplicationComponentNodeContainerId> getNodeVsContainerIdsByTierIds(Collection<Long> var1);

    public void updateTagsOnNode(Set<TagInfo> var1, long var2) throws ServerException;

    public List<ApplicationComponentNodeContainerId> getNodeVsContainerIdsByNodeIds(Long var1) throws ServerException;

    public void updateComponentMetaInfo(long var1, List<NameValuePair> var3) throws ServerException;

    public List<K8sWorkload> getWorkloadIdsByTierId(long var1) throws ServerException;

    public List<K8sPod> getPodIdsByNodeId(Long var1) throws ServerException;
}

