/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.services.model;

import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.AccountRole;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.Permission;
import com.singularity.ee.controller.api.dto.rbac.AccountRoleWithMdsEntityPermissions;
import com.singularity.ee.controller.api.exceptions.ServerException;
import java.util.List;

public interface IAccountRoleManager {
    public static final String ACCOUNT_ADMINISTRATOR_ACCOUNT_ROLE_NAME = "Account Administrator";
    public static final String ADMINISTRATOR_ACCOUNT_ROLE_NAME = "Administrator";
    public static final String USER_ACCOUNT_ROLE_NAME = "User";
    public static final String DASHBOARD_VIEWER_ACCOUNT_ROLE_NAME = "Dashboard Viewer";
    public static final String WORKFLOW_EXECUTOR_ACCOUNT_ROLE_NAME = "Workflow Executor";
    public static final String DBMON_ADMIN_ROLE = "DB Monitoring Administrator";
    public static final String DBMON_USER_ROLE = "DB Monitoring User";
    public static final String ANALYTICS_ADMIN_ROLE = "Analytics Administrator";
    public static final String SIM_ADMIN_ROLE = "Server Monitoring Administrator";
    public static final String SIM_USER_ROLE = "Server Monitoring User";
    public static final String UA_ADMIN_ROLE = "Universal Agent Administrator";
    public static final String UA_USER_ROLE = "Universal Agent User";
    public static final String SUPPORT_USER_ROLE = "Support User";
    public static final String ACCOUNT_ADMINISTRATOR_ACCOUNT_ROLE_DESCRIPTION = "Can access and modify global configuration and view/modify applications and dashboards";
    public static final String ADMINISTRATOR_ACCOUNT_ROLE_DESCRIPTION = "Can view/modify applications and dashboards";
    public static final String USER_ACCOUNT_ROLE_DESCRIPTION = "Can view applications and dashboards but not modify their configuration";
    public static final String DASHBOARD_VIEWER_ACCOUNT_ROLE_DESCRIPTION = "Can view dashboards only";
    public static final String WORKFLOW_EXECUTOR_ACCOUNT_ROLE_DESCRIPTION = "Can execute workflows only";
    public static final String DBMON_ADMIN_ROLE_DESCRIPTION = "Can configure Database Monitoring and view Database Monitoring data.";
    public static final String DBMON_USER_ROLE_DESCRIPTION = "Can view Database Monitoring data.";
    public static final String ANALYTICS_ADMIN_ROLE_DESCRIPTION = "Can configure Analytics data.";
    public static final String SIM_ADMIN_ROLE_DESCRIPTION = "Can configure Server Visibility and view data.";
    public static final String SIM_USER_ROLE_DESCRIPTION = "Can view Server Visibility data.";
    public static final String UA_ADMIN_ROLE_DESCRIPTION = "Can configure Universal Agent and view data.";
    public static final String UA_USER_ROLE_DESCRIPTION = "Can view Universal Agent data.";
    public static final String SUPPORT_USER_ROLE_DESCRIPTION = "Can view applications and dashboards with read only permissions.";

    public AccountRole createAccountRole(AccountRole var1) throws ServerException;

    public void deleteAccountRole(long ... var1) throws ServerException;

    public void deleteAccountRoleInternal(long[] var1, boolean var2) throws ServerException;

    public AccountRole updateAccountRole(AccountRole var1) throws ServerException;

    public void forceUpdateAccountRoleInternal(String var1, Permission[] var2) throws ServerException;

    public String[] getAllAccountRoleNames() throws ServerException;

    public AccountRole[] getAllAccountRoles() throws ServerException;

    public AccountRole[] getAllAccountRoleSummaries() throws ServerException;

    public AccountRole getAccountRoleByName(String var1) throws ServerException;

    public AccountRole getAccountRoleByAccountRoleNameOrKRoleNameCurrentAccount(String var1) throws ServerException;

    public AccountRole getAccountRoleByAccountRoleNameOrKRoleNameForAccount(String var1, String var2) throws ServerException;

    public AccountRole getAccountRoleById(long var1) throws ServerException;

    public AccountRole getAccountRoleByIdByEntity(long var1, EntityDefinition var3) throws ServerException;

    public AccountRole[] getAccountRolesByIdsAndEntityType(Long[] var1, EntityType var2, boolean var3) throws ServerException;

    public AccountRoleWithMdsEntityPermissions[] getRolePermissionsByIdsAndEntityType(long var1, Long[] var3, List<EntityType> var4, boolean var5) throws ServerException;

    public long[] getUserIdsForAccountRole(long var1) throws ServerException;

    public long[] getGroupIdsForAccountRole(long var1) throws ServerException;

    public void addAccountRoleToUsers(long var1, long ... var3) throws ServerException;

    public void removeAccountRoleFromUsers(long var1, long ... var3) throws ServerException;

    public void addAccountRoleToGroups(long var1, long ... var3) throws ServerException;

    public void removeAccountRoleFromGroups(long var1, long ... var3) throws ServerException;

    public AccountRole getAccountRoleSummaryById(long var1) throws ServerException;
}

