/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.services.model;

import com.singularity.ee.controller.api.dto.Account;
import com.singularity.ee.controller.api.dto.AccountProfile;
import com.singularity.ee.controller.api.dto.AccountPurgeStatus;
import com.singularity.ee.controller.api.dto.AccountSummary;
import com.singularity.ee.controller.api.dto.NotificationConfig;
import com.singularity.ee.controller.api.dto.SecurityProviderType;
import com.singularity.ee.controller.api.dto.User;
import com.singularity.ee.controller.api.exceptions.IllegalOperationException;
import com.singularity.ee.controller.api.exceptions.PermissionException;
import com.singularity.ee.controller.api.exceptions.ServerException;
import com.singularity.ee.controller.api.exceptions.UnauthorizedAccessException;
import com.singularity.ee.controller.beans.model.EnumDeleteAccountReturnStatus;
import java.io.IOException;
import java.util.Date;

public interface IAccountManager {
    public Account createAccount(Account var1, User var2) throws ServerException;

    public EnumDeleteAccountReturnStatus deleteAccount(long var1) throws ServerException;

    public EnumDeleteAccountReturnStatus deleteAndPurgeAccount(long var1) throws ServerException;

    public void purgeAccounts();

    public Account updateAccount(Account var1) throws ServerException;

    public Account[] getAllAccounts() throws ServerException;

    public Account[] getAllAccountsForUi() throws ServerException;

    public String[] getAllAccountNames() throws ServerException;

    public Account getAccountById(long var1) throws UnauthorizedAccessException, IllegalOperationException, PermissionException;

    public Account getAccountByName(String var1) throws ServerException;

    public long getAccountIdByName(String var1);

    public NotificationConfig updateNotificationConfig(NotificationConfig var1) throws ServerException;

    public NotificationConfig getNotificationConfig() throws ServerException;

    public NotificationConfig getNotificationConfigForUI() throws ServerException;

    public NotificationConfig getNotificationConfigForScheduledReports() throws ServerException;

    public boolean isNotificationConfigValid() throws ServerException;

    @Deprecated
    public Account getCurrentAccount() throws ServerException;

    @Deprecated
    public Account getCurrentAccountSafe() throws ServerException;

    public Account getCurrentAccountDetails() throws ServerException;

    public Account getCurrentAccountDetailsForFM() throws ServerException;

    public String getCurrentGlobalAccountName() throws ServerException;

    public AccountSummary getCurrentAccountSummary() throws ServerException;

    public Account updateAccessKey(long var1) throws ServerException;

    public void reenableAccount(String var1) throws ServerException;

    public AccountProfile getCurrentAccountProfile() throws ServerException;

    public AccountProfile getCurrentAccountProfile(long var1) throws ServerException;

    public void setStrongPasswordsRequiredForCurrentAccount(boolean var1) throws ServerException;

    public boolean areStrongPasswordsRequiredForCurrentAccount() throws ServerException;

    public SecurityProviderType getSecurityProviderForAccount(String var1) throws ServerException;

    public SecurityProviderType getSecurityProviderType() throws ServerException;

    public void setEumAccountName(String var1) throws ServerException;

    public void setEUMCloudLicenseKey(String var1) throws ServerException;

    public Account getAccountWithAPMLicensingById(long var1) throws ServerException;

    public Account updateAccountWithAPMLicensing(Account var1) throws ServerException;

    public Account createAccountWithAPMLicensing(Account var1, User var2) throws ServerException;

    public String getControllerUrlForCurrentAccount() throws ServerException;

    public void sendPasswordResetEmailToAccountOwner(User var1, Account var2) throws ServerException;

    public void enableMdsTransactionConfigForNewApps(long var1) throws ServerException;

    public void disableMdsTransactionConfigForNewApps(long var1) throws ServerException;

    public void enableMdsBackendConfigForNewApps(long var1) throws ServerException;

    public void disableMdsBackendConfigForNewApps(long var1) throws ServerException;

    public void enableMdsConfigValidationForAccount(long var1) throws ServerException;

    public void disableMdsConfigValidationForAccount(long var1) throws ServerException;

    public AccountPurgeStatus getPurgeStatus(long var1) throws ServerException, IOException;

    public Account[] getDeletedAccountsMatchingName(String var1);

    public void updateSystemAccountExpirationDate(Date var1) throws ServerException;
}

