/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.services.manage;

import com.singularity.ee.controller.api.constants.AgentType;
import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.dto.AAppDynamicsAgent;
import com.singularity.ee.controller.api.dto.MachineAgent;
import com.singularity.ee.controller.api.dto.MachineInstance;
import com.singularity.ee.controller.api.dto.alerting.HealthRuleEntityDTO;
import com.singularity.ee.controller.api.dto.alerting.SimMachineTypeDto;
import com.singularity.ee.controller.api.exceptions.ServerException;
import com.singularity.ee.controller.api.exceptions.UnauthorizedAccessException;
import java.util.List;
import java.util.Set;

public interface IMachineInstanceManager {
    public MachineInstance getMachineById(long var1) throws ServerException;

    public MachineInstance getRunningMachineByName(String var1) throws ServerException;

    public MachineInstance[] getAllStandaloneMachines() throws ServerException;

    public MachineInstance[] getAllMachines() throws ServerException;

    public MachineInstance[] getAllMachinesForApplication(long var1) throws ServerException;

    public MachineInstance[] getAllMachinesForApplicationV2(long var1, long var3) throws ServerException;

    public AAppDynamicsAgent getMachineAgentByMachineId(long var1) throws ServerException;

    public void requestAgentReregistration(long var1) throws ServerException;

    public boolean isAgentReRegistrationRequested(long var1) throws ServerException;

    public void cancelAgentReregistrationRequest(long var1) throws ServerException;

    public void toggleEnableForAgents(boolean var1, long[] var2, EntityType var3) throws ServerException;

    public boolean isAgentDisabled(long var1) throws ServerException;

    public boolean deleteUnassociatedMachine(long var1) throws ServerException;

    public long[] getAllMachineIdsForApplication(long var1) throws ServerException;

    public boolean isApplicationPresentOnMachine(long var1, long var3) throws ServerException;

    public void markMachineNonHistorical(long var1);

    public void markNodeNonHistorical(long var1, AgentType var3);

    public boolean isMachineEligibleForReuse(long var1, boolean var3);

    public void populateProcessorInformation(long var1, MachineAgent var3) throws ServerException;

    public List<HealthRuleEntityDTO> getAliveMachines(long var1) throws UnauthorizedAccessException;

    public List<HealthRuleEntityDTO> getServerDetailsFromCacheByAccountId(Set<SimMachineTypeDto> var1) throws UnauthorizedAccessException;
}

