/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.services.manage;

import com.singularity.ee.controller.api.constants.EntityType;
import com.singularity.ee.controller.api.constants.PermissionAction;
import com.singularity.ee.controller.api.dto.AgentConfiguration;
import com.singularity.ee.controller.api.dto.AgentDiagnosticStats;
import com.singularity.ee.controller.api.dto.AppServerAgent;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.dto.HierarchicalConfigKey;
import com.singularity.ee.controller.api.dto.MachineAgent;
import com.singularity.ee.controller.api.dto.Property;
import com.singularity.ee.controller.api.dto.TimeRangeSpecifier;
import com.singularity.ee.controller.api.dto.dbmon.DBAgent;
import com.singularity.ee.controller.api.dto.dbmon.DBAgentListItem;
import com.singularity.ee.controller.api.exceptions.ServerException;
import java.util.Map;
import java.util.Optional;

public interface IAgentManager {
    public AppServerAgent getAppServerAgentByNodeId(long var1) throws ServerException;

    public AppServerAgent[] getAppServerAgents() throws ServerException;

    public MachineAgent[] getMachineAgents() throws ServerException;

    public DBAgent[] getDBAgents() throws ServerException;

    public Optional<Map<String, String>> getProperties(long var1, long var3);

    public Optional<Map<String, String>> getPropertiesByNodeId(long var1, long var3);

    public Optional<Map<Long, Map<String, String>>> getAllDBAgentProperties(long var1);

    public DBAgent[] getDBAgents(Boolean var1) throws ServerException;

    public DBAgent[] getDBAgents(long var1, Boolean var3) throws ServerException;

    public DBAgent getDBAgentByIdIncludingDownAgents(long var1) throws ServerException;

    public DBAgent getDBAgentByAccountIdById(long var1, long var3, Boolean var5) throws ServerException;

    public Map<Long, Long> getDBAgentIdVsNodeIdMapping(long var1);

    public String[] getAvailableDBAgentNames() throws ServerException;

    public Long getDBAgentIdByName(String var1) throws ServerException;

    public DBAgentListItem getDBAgentListItemById(long var1) throws ServerException;

    public AgentDiagnosticStats getAgentDiagnosticStats(EntityDefinition var1, TimeRangeSpecifier var2) throws ServerException;

    public AgentConfiguration updateAgentConfiguration(AgentConfiguration var1) throws ServerException;

    public AgentConfiguration updateAgentConfigurationAndToggleAgentEnableStatusIfNeeded(AgentConfiguration var1) throws ServerException;

    public EntityDefinition[] updateAgentPropertyForAllNodes(long var1, Property var3) throws ServerException;

    public boolean updateAgentProperty(HierarchicalConfigKey var1, Property var2) throws ServerException;

    public void copyAgentConfiguration(HierarchicalConfigKey var1, HierarchicalConfigKey var2) throws ServerException;

    public void overrideChildrenAgentConfiguration(HierarchicalConfigKey var1) throws ServerException;

    public AgentConfiguration getAgentConfiguration(HierarchicalConfigKey var1, boolean var2) throws ServerException;

    public AgentConfiguration getAgentConfigurationNoValidation(HierarchicalConfigKey var1, boolean var2) throws ServerException;

    public AgentConfiguration[] getAllSummaryAgentConfigurationsUnderApplication(long var1) throws ServerException;

    public void toggleAgentEnableForEntities(boolean var1, long[] var2, EntityType var3, boolean var4) throws ServerException;

    public boolean isNodeMonitoringDisabled(long var1);

    public void setAgentDisabledPropertyOnAllAgentsOfApplications(long[] var1, boolean var2) throws ServerException;

    public void requestDBAgentReregistration(long ... var1) throws ServerException;

    public boolean isDBAgentReRegistrationRequested(long var1) throws ServerException;

    public void removeChildrenCustomAgentConfiguration(HierarchicalConfigKey var1) throws ServerException;

    public void deleteCustomAgentConfiguration(AgentConfiguration var1) throws ServerException;

    public boolean isAdminUser() throws ServerException;

    public void checkAdminPermission() throws ServerException;

    public boolean checkUserPermission(EntityDefinition var1, PermissionAction var2) throws ServerException;
}

