/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.logging;

import com.singularity.ee.controller.api.dto.ContextualLoggingType;
import org.slf4j.Logger;
import org.slf4j.Marker;

public class ContextualLogger
implements Logger {
    private Logger log;
    private long nodeId = 0L;
    private ContextualLoggingType contextualLoggingType = null;
    private String nodeName = null;

    public ContextualLogger(Logger log) {
        this.log = log;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(long nodeId) {
        this.nodeId = nodeId;
    }

    public boolean isContextualLoggingEnabled() {
        return this.nodeId != 0L;
    }

    private String formatMsg(String msg) {
        if (this.isContextualLoggingEnabled()) {
            return "ContextualLogging(" + (Object)((Object)this.contextualLoggingType) + ", Node Name: " + this.nodeName + " NodeId: " + this.nodeId + "): " + msg;
        }
        return msg;
    }

    public void setContextualLoggingType(ContextualLoggingType contextualLoggingType) {
        this.contextualLoggingType = contextualLoggingType;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getName() {
        return this.log.getName();
    }

    public boolean isTraceEnabled() {
        if (this.isContextualLoggingEnabled()) {
            return true;
        }
        return this.log.isTraceEnabled();
    }

    public void trace(String msg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(msg));
        } else {
            this.log.trace(msg);
        }
    }

    public void trace(String format, Object arg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(format), arg);
        } else {
            this.log.trace(format, arg);
        }
    }

    public void trace(String format, Object arg1, Object arg2) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(format), arg1, arg2);
        } else {
            this.log.trace(format, arg1, arg2);
        }
    }

    public void trace(String format, Object ... arguments) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(format), arguments);
        } else {
            this.log.trace(format, arguments);
        }
    }

    public void trace(String msg, Throwable t) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(msg), t);
        } else {
            this.log.trace(msg, t);
        }
    }

    public boolean isTraceEnabled(Marker marker) {
        if (this.isContextualLoggingEnabled()) {
            return true;
        }
        return this.log.isTraceEnabled(marker);
    }

    public void trace(Marker marker, String msg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(msg));
        } else {
            this.log.trace(marker, msg);
        }
    }

    public void trace(Marker marker, String format, Object arg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(format), arg);
        } else {
            this.log.trace(marker, format, arg);
        }
    }

    public void trace(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(format), arg1, arg2);
        } else {
            this.log.trace(marker, format, arg1, arg2);
        }
    }

    public void trace(Marker marker, String format, Object ... argArray) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(format), argArray);
        } else {
            this.log.trace(marker, format, argArray);
        }
    }

    public void trace(Marker marker, String msg, Throwable t) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(msg), t);
        } else {
            this.log.trace(marker, msg, t);
        }
    }

    public boolean isDebugEnabled() {
        if (this.isContextualLoggingEnabled()) {
            return true;
        }
        return this.log.isDebugEnabled();
    }

    public void debug(String msg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(msg));
        } else {
            this.log.debug(msg);
        }
    }

    public void debug(String format, Object arg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(format), arg);
        } else {
            this.log.debug(format, arg);
        }
    }

    public void debug(String format, Object arg1, Object arg2) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(format), arg1, arg2);
        } else {
            this.log.debug(format, arg1, arg2);
        }
    }

    public void debug(String format, Object ... arguments) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(format), arguments);
        } else {
            this.log.debug(format, arguments);
        }
    }

    public void debug(String msg, Throwable t) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(this.formatMsg(msg), t);
        } else {
            this.log.debug(msg, t);
        }
    }

    public boolean isDebugEnabled(Marker marker) {
        if (this.isContextualLoggingEnabled()) {
            return true;
        }
        return this.log.isDebugEnabled(marker);
    }

    public void debug(Marker marker, String msg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(msg));
        } else {
            this.log.debug(marker, msg);
        }
    }

    public void debug(Marker marker, String format, Object arg) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(format), arg);
        } else {
            this.log.debug(marker, format, arg);
        }
    }

    public void debug(Marker marker, String format, Object arg1, Object arg2) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(format), arg1, arg2);
        } else {
            this.log.debug(marker, format, arg1, arg2);
        }
    }

    public void debug(Marker marker, String format, Object ... arguments) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(format), arguments);
        } else {
            this.log.debug(marker, format, arguments);
        }
    }

    public void debug(Marker marker, String msg, Throwable t) {
        if (this.isContextualLoggingEnabled()) {
            this.log.info(marker, this.formatMsg(msg), t);
        } else {
            this.log.debug(marker, msg, t);
        }
    }

    public boolean isInfoEnabled() {
        return this.log.isInfoEnabled();
    }

    public void info(String msg) {
        this.log.info(this.formatMsg(msg));
    }

    public void info(String format, Object arg) {
        this.log.info(this.formatMsg(format), arg);
    }

    public void info(String format, Object arg1, Object arg2) {
        this.log.info(this.formatMsg(format), arg1, arg2);
    }

    public void info(String format, Object ... arguments) {
        this.log.info(this.formatMsg(format), arguments);
    }

    public void info(String msg, Throwable t) {
        this.log.info(this.formatMsg(msg), t);
    }

    public boolean isInfoEnabled(Marker marker) {
        return this.log.isInfoEnabled(marker);
    }

    public void info(Marker marker, String msg) {
        this.log.info(marker, this.formatMsg(msg));
    }

    public void info(Marker marker, String format, Object arg) {
        this.log.info(marker, this.formatMsg(format), arg);
    }

    public void info(Marker marker, String format, Object arg1, Object arg2) {
        this.log.info(marker, this.formatMsg(format), arg1, arg2);
    }

    public void info(Marker marker, String format, Object ... arguments) {
        this.log.info(marker, this.formatMsg(format), arguments);
    }

    public void info(Marker marker, String msg, Throwable t) {
        this.log.info(marker, this.formatMsg(msg), t);
    }

    public boolean isWarnEnabled() {
        return this.log.isWarnEnabled();
    }

    public void warn(String msg) {
        this.log.warn(this.formatMsg(msg));
    }

    public void warn(String format, Object arg) {
        this.log.warn(this.formatMsg(format), arg);
    }

    public void warn(String format, Object ... arguments) {
        this.log.warn(this.formatMsg(format), arguments);
    }

    public void warn(String format, Object arg1, Object arg2) {
        this.log.warn(this.formatMsg(format), arg1, arg2);
    }

    public void warn(String msg, Throwable t) {
        this.log.warn(this.formatMsg(msg), t);
    }

    public boolean isWarnEnabled(Marker marker) {
        return this.log.isWarnEnabled(marker);
    }

    public void warn(Marker marker, String msg) {
        this.log.warn(marker, this.formatMsg(msg));
    }

    public void warn(Marker marker, String format, Object arg) {
        this.log.warn(marker, this.formatMsg(format), arg);
    }

    public void warn(Marker marker, String format, Object arg1, Object arg2) {
        this.log.warn(marker, this.formatMsg(format), arg1, arg2);
    }

    public void warn(Marker marker, String format, Object ... arguments) {
        this.log.warn(marker, this.formatMsg(format), arguments);
    }

    public void warn(Marker marker, String msg, Throwable t) {
        this.log.warn(marker, this.formatMsg(msg), t);
    }

    public boolean isErrorEnabled() {
        return this.log.isErrorEnabled();
    }

    public void error(String msg) {
        this.log.error(this.formatMsg(msg));
    }

    public void error(String format, Object arg) {
        this.log.error(this.formatMsg(format), arg);
    }

    public void error(String format, Object arg1, Object arg2) {
        this.log.error(this.formatMsg(format), arg1, arg2);
    }

    public void error(String format, Object ... arguments) {
        this.log.error(this.formatMsg(format), arguments);
    }

    public void error(String msg, Throwable t) {
        this.log.error(this.formatMsg(msg), t);
    }

    public boolean isErrorEnabled(Marker marker) {
        return this.log.isErrorEnabled(marker);
    }

    public void error(Marker marker, String msg) {
        this.log.error(marker, this.formatMsg(msg));
    }

    public void error(Marker marker, String format, Object arg) {
        this.log.error(marker, this.formatMsg(format), arg);
    }

    public void error(Marker marker, String format, Object arg1, Object arg2) {
        this.log.error(marker, this.formatMsg(format), arg1, arg2);
    }

    public void error(Marker marker, String format, Object ... arguments) {
        this.log.error(marker, this.formatMsg(format), arguments);
    }

    public void error(Marker marker, String msg, Throwable t) {
        this.log.error(marker, this.formatMsg(msg), t);
    }
}

