/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.exceptions;

import com.singularity.ee.controller.api.constants.PermissionAction;
import com.singularity.ee.controller.api.dto.EntityDefinition;
import com.singularity.ee.controller.api.exceptions.ServerException;
import javax.ejb.ApplicationException;

@ApplicationException(rollback=true)
public class PermissionException
extends ServerException {
    private static final long serialVersionUID = 1L;
    private static final String EXCEPTION_ID = "ID000458";
    private EntityDefinition affectedEntity;
    private PermissionAction action;

    public PermissionException() {
    }

    public PermissionException(String message) {
        super(PermissionException.buildExceptionMessage(message));
    }

    public PermissionException(String message, Throwable cause, PermissionAction action, EntityDefinition affectedEntity) {
        super(PermissionException.buildExceptionMessage(message), cause);
        this.setAction(action);
        this.setAffectedEntity(affectedEntity);
    }

    public PermissionException(String message, PermissionAction action, EntityDefinition affectedEntity) {
        super(PermissionException.buildExceptionMessage(message));
        this.setAction(action);
        this.setAffectedEntity(affectedEntity);
    }

    public PermissionException(Throwable cause, PermissionAction action, EntityDefinition affectedEntity) {
        super(PermissionException.buildExceptionMessage(cause.getMessage()), cause);
        this.setAction(action);
        this.setAffectedEntity(affectedEntity);
    }

    public void setAffectedEntity(EntityDefinition affectedEntity) {
        this.affectedEntity = affectedEntity;
    }

    public EntityDefinition getAffectedEntity() {
        return this.affectedEntity;
    }

    public void setAction(PermissionAction action) {
        this.action = action;
    }

    public PermissionAction getAction() {
        return this.action;
    }

    private static String buildExceptionMessage(String message) {
        return String.format("%s: %s", EXCEPTION_ID, message);
    }
}

