/*
 * Decompiled with CFR 0.152.
 */
package com.singularity.ee.controller.api.dto.util;

import com.appdynamics.ui.codegen.annotations.TSCodeGen;
import com.singularity.ee.controller.api.dto.Application;
import com.singularity.ee.controller.api.dto.SeveritySummary;
import com.singularity.ee.controller.api.dto.pages.applications.AllApplicationDashboardItem;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.ApplicationPerformanceSummary;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceStateSummary;
import com.singularity.ee.controller.api.dto.transactionmonitor.transactiondefinition.PerformanceStats;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@TSCodeGen(exclude=true)
public class DTOTranslationUtil {
    public static List<AllApplicationDashboardItem> translateToAllApplicationDashboardItem(Application[] applications, ApplicationPerformanceSummary[] summaries) {
        return DTOTranslationUtil.translateToAllApplicationDashboardItem(applications, null, summaries);
    }

    public static List<AllApplicationDashboardItem> translateToAllApplicationDashboardItem(Application[] applications, Map<Long, Integer> positionIndexer, ApplicationPerformanceSummary[] summaries) {
        if (applications.length == 0) {
            return Collections.emptyList();
        }
        HashMap<Long, ApplicationPerformanceSummary> summaryHashMap = new HashMap<Long, ApplicationPerformanceSummary>();
        for (ApplicationPerformanceSummary summary : summaries) {
            summaryHashMap.put(summary.getApplicationId(), summary);
        }
        AllApplicationDashboardItem[] orderedApplications = new AllApplicationDashboardItem[applications.length];
        for (int i = 0; i < applications.length; ++i) {
            Application application = applications[i];
            AllApplicationDashboardItem dashboardItem = new AllApplicationDashboardItem();
            dashboardItem.setName(application.getName());
            dashboardItem.setId(application.getId());
            dashboardItem.setApplicationTypeInfo(application.getApplicationTypeInfo());
            ApplicationPerformanceSummary summary = (ApplicationPerformanceSummary)summaryHashMap.get(application.getId());
            if (summary != null) {
                SeveritySummary severitySummary;
                PerformanceStateSummary serverHealthSummary;
                PerformanceStateSummary busTxHealthsummary;
                PerformanceStats stats = summary.getStats();
                if (stats != null) {
                    if (stats.getNumberOfCalls() != null) {
                        dashboardItem.setNumberOfCalls(stats.getNumberOfCalls().getValue());
                    }
                    if (stats.getCallsPerMinute() != null) {
                        dashboardItem.setCallsPerMinute(stats.getCallsPerMinute().getValue());
                    }
                    if (stats.getErrorsPerMinute() != null) {
                        dashboardItem.setErrorsPerMinute(stats.getErrorsPerMinute().getValue());
                    }
                    if (stats.getNumberOfErrors() != null) {
                        dashboardItem.setNumberOfErrors(stats.getNumberOfErrors().getValue());
                    }
                    if (stats.getAverageResponseTime() != null) {
                        dashboardItem.setAverageResponseTime(stats.getAverageResponseTime().getValue());
                    }
                    dashboardItem.setErrorsPercent(stats.getErrorPercentage());
                }
                if ((busTxHealthsummary = summary.getTransactionsStateSummary()) != null) {
                    dashboardItem.setBtHealthCritical(busTxHealthsummary.getCritical());
                    dashboardItem.setBtHealthWarning(busTxHealthsummary.getWarning());
                    dashboardItem.setBtHealthNormal(busTxHealthsummary.getNormal());
                }
                if ((serverHealthSummary = summary.getNodesHealthStateSummary()) != null) {
                    dashboardItem.setServerHealthCritical(serverHealthSummary.getCritical());
                    dashboardItem.setServerHealthWarning(serverHealthSummary.getWarning());
                    dashboardItem.setServerHealthNormal(serverHealthSummary.getNormal());
                }
                if ((severitySummary = summary.getIncidentSeveritySummary()) != null) {
                    dashboardItem.setSeveritySummary(severitySummary);
                }
            }
            dashboardItem.setApplicationTypeInfo(application.getApplicationTypeInfo());
            if (positionIndexer == null) {
                orderedApplications[i] = dashboardItem;
                continue;
            }
            orderedApplications[positionIndexer.get((Object)Long.valueOf((long)application.getId())).intValue()] = dashboardItem;
        }
        return Arrays.asList(orderedApplications);
    }
}

